package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListSolutionVersionsResponse(
    solutionVersions: Option[
      Iterable[zio.aws.personalize.model.SolutionVersionSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse = {
    import ListSolutionVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse
      .builder()
      .optionallyWith(
        solutionVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.solutionVersions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly =
    zio.aws.personalize.model.ListSolutionVersionsResponse.wrap(buildAwsValue())
}
object ListSolutionVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListSolutionVersionsResponse =
      zio.aws.personalize.model.ListSolutionVersionsResponse(
        solutionVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def solutionVersions: Option[
      List[zio.aws.personalize.model.SolutionVersionSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSolutionVersions: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("solutionVersions", solutionVersions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse
  ) extends zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly {
    override val solutionVersions: Option[
      List[zio.aws.personalize.model.SolutionVersionSummary.ReadOnly]
    ] = scala
      .Option(impl.solutionVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.SolutionVersionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse
  ): zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
