package zio.aws.personalize.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectiveSensitivity {
  def unwrap
      : software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity
}
object ObjectiveSensitivity {
  def wrap(
      value: software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity
  ): zio.aws.personalize.model.ObjectiveSensitivity = value match {
    case software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.OFF =>
      val r = OFF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.personalize.model.ObjectiveSensitivity {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity =
      software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.UNKNOWN_TO_SDK_VERSION
  }
  case object LOW extends zio.aws.personalize.model.ObjectiveSensitivity {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity =
      software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.LOW
  }
  case object MEDIUM extends zio.aws.personalize.model.ObjectiveSensitivity {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity =
      software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.MEDIUM
  }
  case object HIGH extends zio.aws.personalize.model.ObjectiveSensitivity {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity =
      software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.HIGH
  }
  case object OFF extends zio.aws.personalize.model.ObjectiveSensitivity {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity =
      software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity.OFF
  }
}
