package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Date, Status, Arn, Name}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RecipeSummary(
    name: Option[Name] = None,
    recipeArn: Option[Arn] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    domain: Option[zio.aws.personalize.model.Domain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.RecipeSummary = {
    import RecipeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.RecipeSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.RecipeSummary.ReadOnly =
    zio.aws.personalize.model.RecipeSummary.wrap(buildAwsValue())
}
object RecipeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.RecipeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.RecipeSummary =
      zio.aws.personalize.model.RecipeSummary(
        name.map(value => value),
        recipeArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        domain.map(value => value)
      )
    def name: Option[Name]
    def recipeArn: Option[Arn]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def domain: Option[zio.aws.personalize.model.Domain]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.RecipeSummary
  ) extends zio.aws.personalize.model.RecipeSummary.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val recipeArn: Option[Arn] = scala
      .Option(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val domain: Option[zio.aws.personalize.model.Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.RecipeSummary
  ): zio.aws.personalize.model.RecipeSummary.ReadOnly = new Wrapper(impl)
}
