package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Recommender(
    recommenderArn: Option[Arn] = None,
    datasetGroupArn: Option[Arn] = None,
    name: Option[Name] = None,
    recipeArn: Option[Arn] = None,
    recommenderConfig: Option[zio.aws.personalize.model.RecommenderConfig] =
      None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    status: Option[Status] = None,
    failureReason: Option[FailureReason] = None,
    latestRecommenderUpdate: Option[
      zio.aws.personalize.model.RecommenderUpdateSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Recommender = {
    import Recommender.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Recommender
      .builder()
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(recommenderConfig.map(value => value.buildAwsValue()))(
        _.recommenderConfig
      )
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        latestRecommenderUpdate.map(value => value.buildAwsValue())
      )(_.latestRecommenderUpdate)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Recommender.ReadOnly =
    zio.aws.personalize.model.Recommender.wrap(buildAwsValue())
}
object Recommender {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Recommender
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Recommender =
      zio.aws.personalize.model.Recommender(
        recommenderArn.map(value => value),
        datasetGroupArn.map(value => value),
        name.map(value => value),
        recipeArn.map(value => value),
        recommenderConfig.map(value => value.asEditable),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        status.map(value => value),
        failureReason.map(value => value),
        latestRecommenderUpdate.map(value => value.asEditable)
      )
    def recommenderArn: Option[Arn]
    def datasetGroupArn: Option[Arn]
    def name: Option[Name]
    def recipeArn: Option[Arn]
    def recommenderConfig
        : Option[zio.aws.personalize.model.RecommenderConfig.ReadOnly]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def status: Option[Status]
    def failureReason: Option[FailureReason]
    def latestRecommenderUpdate
        : Option[zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly]
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getRecommenderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("recommenderConfig", recommenderConfig)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getLatestRecommenderUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "latestRecommenderUpdate",
      latestRecommenderUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Recommender
  ) extends zio.aws.personalize.model.Recommender.ReadOnly {
    override val recommenderArn: Option[Arn] = scala
      .Option(impl.recommenderArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val recipeArn: Option[Arn] = scala
      .Option(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val recommenderConfig
        : Option[zio.aws.personalize.model.RecommenderConfig.ReadOnly] = scala
      .Option(impl.recommenderConfig())
      .map(value => zio.aws.personalize.model.RecommenderConfig.wrap(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val latestRecommenderUpdate
        : Option[zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly] =
      scala
        .Option(impl.latestRecommenderUpdate())
        .map(value =>
          zio.aws.personalize.model.RecommenderUpdateSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Recommender
  ): zio.aws.personalize.model.Recommender.ReadOnly = new Wrapper(impl)
}
