package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  PerformAutoML,
  Status,
  Date,
  Arn,
  EventType,
  PerformHPO,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Solution(
    name: Option[Name] = None,
    solutionArn: Option[Arn] = None,
    performHPO: Option[PerformHPO] = None,
    performAutoML: Option[PerformAutoML] = None,
    recipeArn: Option[Arn] = None,
    datasetGroupArn: Option[Arn] = None,
    eventType: Option[EventType] = None,
    solutionConfig: Option[zio.aws.personalize.model.SolutionConfig] = None,
    autoMLResult: Option[zio.aws.personalize.model.AutoMLResult] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    latestSolutionVersion: Option[
      zio.aws.personalize.model.SolutionVersionSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Solution = {
    import Solution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Solution
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .optionallyWith(
        performHPO.map(value => PerformHPO.unwrap(value): java.lang.Boolean)
      )(_.performHPO)
      .optionallyWith(
        performAutoML.map(value =>
          PerformAutoML.unwrap(value): java.lang.Boolean
        )
      )(_.performAutoML)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        eventType.map(value => EventType.unwrap(value): java.lang.String)
      )(_.eventType)
      .optionallyWith(solutionConfig.map(value => value.buildAwsValue()))(
        _.solutionConfig
      )
      .optionallyWith(autoMLResult.map(value => value.buildAwsValue()))(
        _.autoMLResult
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        latestSolutionVersion.map(value => value.buildAwsValue())
      )(_.latestSolutionVersion)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Solution.ReadOnly =
    zio.aws.personalize.model.Solution.wrap(buildAwsValue())
}
object Solution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Solution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Solution =
      zio.aws.personalize.model.Solution(
        name.map(value => value),
        solutionArn.map(value => value),
        performHPO.map(value => value),
        performAutoML.map(value => value),
        recipeArn.map(value => value),
        datasetGroupArn.map(value => value),
        eventType.map(value => value),
        solutionConfig.map(value => value.asEditable),
        autoMLResult.map(value => value.asEditable),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        latestSolutionVersion.map(value => value.asEditable)
      )
    def name: Option[Name]
    def solutionArn: Option[Arn]
    def performHPO: Option[PerformHPO]
    def performAutoML: Option[PerformAutoML]
    def recipeArn: Option[Arn]
    def datasetGroupArn: Option[Arn]
    def eventType: Option[EventType]
    def solutionConfig
        : Option[zio.aws.personalize.model.SolutionConfig.ReadOnly]
    def autoMLResult: Option[zio.aws.personalize.model.AutoMLResult.ReadOnly]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def latestSolutionVersion
        : Option[zio.aws.personalize.model.SolutionVersionSummary.ReadOnly]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
    def getPerformHPO: ZIO[Any, AwsError, PerformHPO] =
      AwsError.unwrapOptionField("performHPO", performHPO)
    def getPerformAutoML: ZIO[Any, AwsError, PerformAutoML] =
      AwsError.unwrapOptionField("performAutoML", performAutoML)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getEventType: ZIO[Any, AwsError, EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getSolutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("solutionConfig", solutionConfig)
    def getAutoMLResult
        : ZIO[Any, AwsError, zio.aws.personalize.model.AutoMLResult.ReadOnly] =
      AwsError.unwrapOptionField("autoMLResult", autoMLResult)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getLatestSolutionVersion: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
    ] =
      AwsError.unwrapOptionField("latestSolutionVersion", latestSolutionVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Solution
  ) extends zio.aws.personalize.model.Solution.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val solutionArn: Option[Arn] = scala
      .Option(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val performHPO: Option[PerformHPO] = scala
      .Option(impl.performHPO())
      .map(value => zio.aws.personalize.model.primitives.PerformHPO(value))
    override val performAutoML: Option[PerformAutoML] = scala
      .Option(impl.performAutoML())
      .map(value => zio.aws.personalize.model.primitives.PerformAutoML(value))
    override val recipeArn: Option[Arn] = scala
      .Option(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val eventType: Option[EventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.personalize.model.primitives.EventType(value))
    override val solutionConfig
        : Option[zio.aws.personalize.model.SolutionConfig.ReadOnly] = scala
      .Option(impl.solutionConfig())
      .map(value => zio.aws.personalize.model.SolutionConfig.wrap(value))
    override val autoMLResult
        : Option[zio.aws.personalize.model.AutoMLResult.ReadOnly] = scala
      .Option(impl.autoMLResult())
      .map(value => zio.aws.personalize.model.AutoMLResult.wrap(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val latestSolutionVersion
        : Option[zio.aws.personalize.model.SolutionVersionSummary.ReadOnly] =
      scala
        .Option(impl.latestSolutionVersion())
        .map(value =>
          zio.aws.personalize.model.SolutionVersionSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Solution
  ): zio.aws.personalize.model.Solution.ReadOnly = new Wrapper(impl)
}
