package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Date, Status, Arn, Name}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SolutionSummary(
    name: Option[Name] = None,
    solutionArn: Option[Arn] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.SolutionSummary = {
    import SolutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.SolutionSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.SolutionSummary.ReadOnly =
    zio.aws.personalize.model.SolutionSummary.wrap(buildAwsValue())
}
object SolutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.SolutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.SolutionSummary =
      zio.aws.personalize.model.SolutionSummary(
        name.map(value => value),
        solutionArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Option[Name]
    def solutionArn: Option[Arn]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.SolutionSummary
  ) extends zio.aws.personalize.model.SolutionSummary.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val solutionArn: Option[Arn] = scala
      .Option(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.SolutionSummary
  ): zio.aws.personalize.model.SolutionSummary.ReadOnly = new Wrapper(impl)
}
