package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class StopSolutionVersionCreationRequest(solutionVersionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationRequest = {
    import StopSolutionVersionCreationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationRequest
      .builder()
      .solutionVersionArn(Arn.unwrap(solutionVersionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.StopSolutionVersionCreationRequest.ReadOnly =
    zio.aws.personalize.model.StopSolutionVersionCreationRequest
      .wrap(buildAwsValue())
}
object StopSolutionVersionCreationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.StopSolutionVersionCreationRequest =
      zio.aws.personalize.model
        .StopSolutionVersionCreationRequest(solutionVersionArn)
    def solutionVersionArn: Arn
    def getSolutionVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(solutionVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationRequest
  ) extends zio.aws.personalize.model.StopSolutionVersionCreationRequest.ReadOnly {
    override val solutionVersionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationRequest
  ): zio.aws.personalize.model.StopSolutionVersionCreationRequest.ReadOnly =
    new Wrapper(impl)
}
