package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{ParameterValue, ParameterName}
import scala.jdk.CollectionConverters.*
final case class TunedHPOParams(
    algorithmHyperParameters: Option[Map[ParameterName, ParameterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.TunedHPOParams = {
    import TunedHPOParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.TunedHPOParams
      .builder()
      .optionallyWith(
        algorithmHyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.algorithmHyperParameters)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.TunedHPOParams.ReadOnly =
    zio.aws.personalize.model.TunedHPOParams.wrap(buildAwsValue())
}
object TunedHPOParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.TunedHPOParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.TunedHPOParams =
      zio.aws.personalize.model
        .TunedHPOParams(algorithmHyperParameters.map(value => value))
    def algorithmHyperParameters: Option[Map[ParameterName, ParameterValue]]
    def getAlgorithmHyperParameters
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] = AwsError
      .unwrapOptionField("algorithmHyperParameters", algorithmHyperParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.TunedHPOParams
  ) extends zio.aws.personalize.model.TunedHPOParams.ReadOnly {
    override val algorithmHyperParameters
        : Option[Map[ParameterName, ParameterValue]] = scala
      .Option(impl.algorithmHyperParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.TunedHPOParams
  ): zio.aws.personalize.model.TunedHPOParams.ReadOnly = new Wrapper(impl)
}
