package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{TransactionsPerSecond, Arn}
import scala.jdk.CollectionConverters.*
final case class UpdateCampaignRequest(
    campaignArn: Arn,
    solutionVersionArn: Option[Arn] = None,
    minProvisionedTPS: Option[TransactionsPerSecond] = None,
    campaignConfig: Option[zio.aws.personalize.model.CampaignConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest = {
    import UpdateCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest
      .builder()
      .campaignArn(Arn.unwrap(campaignArn): java.lang.String)
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        minProvisionedTPS.map(value =>
          TransactionsPerSecond.unwrap(value): Integer
        )
      )(_.minProvisionedTPS)
      .optionallyWith(campaignConfig.map(value => value.buildAwsValue()))(
        _.campaignConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.UpdateCampaignRequest.ReadOnly =
    zio.aws.personalize.model.UpdateCampaignRequest.wrap(buildAwsValue())
}
object UpdateCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateCampaignRequest =
      zio.aws.personalize.model.UpdateCampaignRequest(
        campaignArn,
        solutionVersionArn.map(value => value),
        minProvisionedTPS.map(value => value),
        campaignConfig.map(value => value.asEditable)
      )
    def campaignArn: Arn
    def solutionVersionArn: Option[Arn]
    def minProvisionedTPS: Option[TransactionsPerSecond]
    def campaignConfig
        : Option[zio.aws.personalize.model.CampaignConfig.ReadOnly]
    def getCampaignArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(campaignArn)
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getMinProvisionedTPS: ZIO[Any, AwsError, TransactionsPerSecond] =
      AwsError.unwrapOptionField("minProvisionedTPS", minProvisionedTPS)
    def getCampaignConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.CampaignConfig.ReadOnly
    ] = AwsError.unwrapOptionField("campaignConfig", campaignConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest
  ) extends zio.aws.personalize.model.UpdateCampaignRequest.ReadOnly {
    override val campaignArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.campaignArn())
    override val solutionVersionArn: Option[Arn] = scala
      .Option(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val minProvisionedTPS: Option[TransactionsPerSecond] = scala
      .Option(impl.minProvisionedTPS())
      .map(value =>
        zio.aws.personalize.model.primitives.TransactionsPerSecond(value)
      )
    override val campaignConfig
        : Option[zio.aws.personalize.model.CampaignConfig.ReadOnly] = scala
      .Option(impl.campaignConfig())
      .map(value => zio.aws.personalize.model.CampaignConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest
  ): zio.aws.personalize.model.UpdateCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
