package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class UpdateCampaignResponse(campaignArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse = {
    import UpdateCampaignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse
      .builder()
      .optionallyWith(
        campaignArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.campaignArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.UpdateCampaignResponse.ReadOnly =
    zio.aws.personalize.model.UpdateCampaignResponse.wrap(buildAwsValue())
}
object UpdateCampaignResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateCampaignResponse =
      zio.aws.personalize.model
        .UpdateCampaignResponse(campaignArn.map(value => value))
    def campaignArn: Option[Arn]
    def getCampaignArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("campaignArn", campaignArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse
  ) extends zio.aws.personalize.model.UpdateCampaignResponse.ReadOnly {
    override val campaignArn: Option[Arn] = scala
      .Option(impl.campaignArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse
  ): zio.aws.personalize.model.UpdateCampaignResponse.ReadOnly = new Wrapper(
    impl
  )
}
