package zio.aws.personalize
import zio.aws.personalize.model.CreateSolutionResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.personalize.model.{
  DescribeAlgorithmRequest,
  DescribeFeatureTransformationResponse,
  CreateSolutionVersionResponse,
  UpdateRecommenderRequest,
  ListDatasetExportJobsRequest,
  RecipeSummary,
  DatasetSummary,
  DescribeCampaignResponse,
  CreateEventTrackerResponse,
  DatasetGroupSummary,
  DescribeDatasetResponse,
  ListDatasetGroupsResponse,
  DescribeSchemaResponse,
  DescribeRecommenderResponse,
  CreateDatasetRequest,
  CreateSchemaResponse,
  DeleteDatasetGroupResponse,
  DescribeDatasetGroupRequest,
  BatchSegmentJobSummary,
  ListFiltersResponse,
  CreateDatasetExportJobResponse,
  DescribeSchemaRequest,
  DescribeCampaignRequest,
  CreateEventTrackerRequest,
  CreateRecommenderResponse,
  ListBatchInferenceJobsResponse,
  DeleteEventTrackerRequest,
  DatasetExportJobSummary,
  DescribeFilterRequest,
  CreateDatasetExportJobRequest,
  DeleteDatasetGroupRequest,
  CreateBatchInferenceJobResponse,
  DescribeEventTrackerRequest,
  DescribeBatchSegmentJobResponse,
  CreateSolutionResponse,
  DescribeDatasetRequest,
  DescribeSolutionResponse,
  ListSchemasRequest,
  ListDatasetExportJobsResponse,
  ListDatasetImportJobsRequest,
  DescribeBatchSegmentJobRequest,
  CreateSchemaRequest,
  ListEventTrackersRequest,
  DescribeDatasetImportJobRequest,
  ListDatasetImportJobsResponse,
  DescribeSolutionVersionResponse,
  DescribeDatasetGroupResponse,
  CreateDatasetGroupRequest,
  CreateDatasetResponse,
  UpdateCampaignRequest,
  DescribeRecipeRequest,
  GetSolutionMetricsResponse,
  StopSolutionVersionCreationResponse,
  DescribeRecipeResponse,
  DescribeBatchInferenceJobResponse,
  CreateDatasetImportJobResponse,
  ListSchemasResponse,
  DeleteSolutionRequest,
  ListDatasetsRequest,
  DeleteSolutionResponse,
  UpdateRecommenderResponse,
  ListRecommendersRequest,
  CreateFilterRequest,
  FilterSummary,
  DescribeSolutionVersionRequest,
  ListRecipesResponse,
  ListSolutionsResponse,
  EventTrackerSummary,
  ListBatchInferenceJobsRequest,
  DeleteEventTrackerResponse,
  ListFiltersRequest,
  CreateFilterResponse,
  BatchInferenceJobSummary,
  CreateSolutionVersionRequest,
  StopSolutionVersionCreationRequest,
  SolutionSummary,
  ListCampaignsResponse,
  CreateCampaignRequest,
  DeleteRecommenderRequest,
  DeleteSchemaResponse,
  DescribeDatasetExportJobRequest,
  DescribeAlgorithmResponse,
  DeleteCampaignRequest,
  CreateRecommenderRequest,
  DeleteDatasetRequest,
  DeleteRecommenderResponse,
  CreateBatchSegmentJobRequest,
  DescribeDatasetImportJobResponse,
  CreateBatchInferenceJobRequest,
  ListSolutionVersionsResponse,
  DescribeRecommenderRequest,
  DeleteDatasetResponse,
  DescribeSolutionRequest,
  ListBatchSegmentJobsResponse,
  RecommenderSummary,
  CreateBatchSegmentJobResponse,
  DatasetImportJobSummary,
  CampaignSummary,
  DescribeFeatureTransformationRequest,
  ListDatasetGroupsRequest,
  DeleteFilterRequest,
  ListEventTrackersResponse,
  ListRecipesRequest,
  ListCampaignsRequest,
  DescribeDatasetExportJobResponse,
  DeleteCampaignResponse,
  CreateCampaignResponse,
  UpdateCampaignResponse,
  ListDatasetsResponse,
  ListSolutionsRequest,
  CreateSolutionRequest,
  DeleteSchemaRequest,
  DatasetSchemaSummary,
  ListRecommendersResponse,
  DeleteFilterResponse,
  DescribeBatchInferenceJobRequest,
  ListSolutionVersionsRequest,
  GetSolutionMetricsRequest,
  DescribeEventTrackerResponse,
  ListBatchSegmentJobsRequest,
  SolutionVersionSummary,
  DescribeFilterResponse,
  CreateDatasetImportJobRequest,
  CreateDatasetGroupResponse
}
import software.amazon.awssdk.services.personalize.{
  PersonalizeAsyncClientBuilder,
  PersonalizeAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.personalize.paginators.{
  ListBatchInferenceJobsPublisher,
  ListFiltersPublisher,
  ListSchemasPublisher,
  ListDatasetExportJobsPublisher,
  ListBatchSegmentJobsPublisher,
  ListSolutionsPublisher,
  ListDatasetImportJobsPublisher,
  ListDatasetsPublisher,
  ListSolutionVersionsPublisher,
  ListCampaignsPublisher,
  ListDatasetGroupsPublisher,
  ListRecipesPublisher,
  ListEventTrackersPublisher,
  ListRecommendersPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Personalize extends AspectSupport[Personalize] {
  val api: PersonalizeAsyncClient
  def getSolutionMetrics(
      request: zio.aws.personalize.model.GetSolutionMetricsRequest
  ): IO[AwsError, zio.aws.personalize.model.GetSolutionMetricsResponse.ReadOnly]
  def createDataset(
      request: zio.aws.personalize.model.CreateDatasetRequest
  ): IO[AwsError, zio.aws.personalize.model.CreateDatasetResponse.ReadOnly]
  def createEventTracker(
      request: zio.aws.personalize.model.CreateEventTrackerRequest
  ): IO[AwsError, zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly]
  def deleteCampaign(
      request: zio.aws.personalize.model.DeleteCampaignRequest
  ): IO[AwsError, Unit]
  def describeAlgorithm(
      request: zio.aws.personalize.model.DescribeAlgorithmRequest
  ): IO[AwsError, zio.aws.personalize.model.DescribeAlgorithmResponse.ReadOnly]
  def describeDatasetExportJob(
      request: zio.aws.personalize.model.DescribeDatasetExportJobRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeDatasetExportJobResponse.ReadOnly
  ]
  def listCampaigns(
      request: zio.aws.personalize.model.ListCampaignsRequest
  ): ZStream[Any, AwsError, zio.aws.personalize.model.CampaignSummary.ReadOnly]
  def listCampaignsPaginated(
      request: zio.aws.personalize.model.ListCampaignsRequest
  ): IO[AwsError, zio.aws.personalize.model.ListCampaignsResponse.ReadOnly]
  def createDatasetGroup(
      request: zio.aws.personalize.model.CreateDatasetGroupRequest
  ): IO[AwsError, zio.aws.personalize.model.CreateDatasetGroupResponse.ReadOnly]
  def deleteFilter(
      request: zio.aws.personalize.model.DeleteFilterRequest
  ): IO[AwsError, Unit]
  def deleteRecommender(
      request: zio.aws.personalize.model.DeleteRecommenderRequest
  ): IO[AwsError, Unit]
  def createSolution(
      request: zio.aws.personalize.model.CreateSolutionRequest
  ): IO[AwsError, ReadOnly]
  def describeBatchSegmentJob(
      request: zio.aws.personalize.model.DescribeBatchSegmentJobRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeBatchSegmentJobResponse.ReadOnly
  ]
  def createRecommender(
      request: zio.aws.personalize.model.CreateRecommenderRequest
  ): IO[AwsError, zio.aws.personalize.model.CreateRecommenderResponse.ReadOnly]
  def describeBatchInferenceJob(
      request: zio.aws.personalize.model.DescribeBatchInferenceJobRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeBatchInferenceJobResponse.ReadOnly
  ]
  def describeCampaign(
      request: zio.aws.personalize.model.DescribeCampaignRequest
  ): IO[AwsError, zio.aws.personalize.model.DescribeCampaignResponse.ReadOnly]
  def createFilter(
      request: zio.aws.personalize.model.CreateFilterRequest
  ): IO[AwsError, zio.aws.personalize.model.CreateFilterResponse.ReadOnly]
  def listSolutions(
      request: zio.aws.personalize.model.ListSolutionsRequest
  ): ZStream[Any, AwsError, zio.aws.personalize.model.SolutionSummary.ReadOnly]
  def listSolutionsPaginated(
      request: zio.aws.personalize.model.ListSolutionsRequest
  ): IO[AwsError, zio.aws.personalize.model.ListSolutionsResponse.ReadOnly]
  def describeDatasetImportJob(
      request: zio.aws.personalize.model.DescribeDatasetImportJobRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeDatasetImportJobResponse.ReadOnly
  ]
  def describeSolution(
      request: zio.aws.personalize.model.DescribeSolutionRequest
  ): IO[AwsError, zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly]
  def listEventTrackers(
      request: zio.aws.personalize.model.ListEventTrackersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.EventTrackerSummary.ReadOnly
  ]
  def listEventTrackersPaginated(
      request: zio.aws.personalize.model.ListEventTrackersRequest
  ): IO[AwsError, zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly]
  def describeDataset(
      request: zio.aws.personalize.model.DescribeDatasetRequest
  ): IO[AwsError, zio.aws.personalize.model.DescribeDatasetResponse.ReadOnly]
  def createDatasetImportJob(
      request: zio.aws.personalize.model.CreateDatasetImportJobRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.CreateDatasetImportJobResponse.ReadOnly
  ]
  def describeSchema(
      request: zio.aws.personalize.model.DescribeSchemaRequest
  ): IO[AwsError, zio.aws.personalize.model.DescribeSchemaResponse.ReadOnly]
  def createSolutionVersion(
      request: zio.aws.personalize.model.CreateSolutionVersionRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.CreateSolutionVersionResponse.ReadOnly
  ]
  def createDatasetExportJob(
      request: zio.aws.personalize.model.CreateDatasetExportJobRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.CreateDatasetExportJobResponse.ReadOnly
  ]
  def describeRecipe(
      request: zio.aws.personalize.model.DescribeRecipeRequest
  ): IO[AwsError, zio.aws.personalize.model.DescribeRecipeResponse.ReadOnly]
  def deleteSolution(
      request: zio.aws.personalize.model.DeleteSolutionRequest
  ): IO[AwsError, Unit]
  def updateRecommender(
      request: zio.aws.personalize.model.UpdateRecommenderRequest
  ): IO[AwsError, zio.aws.personalize.model.UpdateRecommenderResponse.ReadOnly]
  def deleteDatasetGroup(
      request: zio.aws.personalize.model.DeleteDatasetGroupRequest
  ): IO[AwsError, Unit]
  def listDatasetGroups(
      request: zio.aws.personalize.model.ListDatasetGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.DatasetGroupSummary.ReadOnly
  ]
  def listDatasetGroupsPaginated(
      request: zio.aws.personalize.model.ListDatasetGroupsRequest
  ): IO[AwsError, zio.aws.personalize.model.ListDatasetGroupsResponse.ReadOnly]
  def createBatchInferenceJob(
      request: zio.aws.personalize.model.CreateBatchInferenceJobRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.CreateBatchInferenceJobResponse.ReadOnly
  ]
  def stopSolutionVersionCreation(
      request: zio.aws.personalize.model.StopSolutionVersionCreationRequest
  ): IO[AwsError, Unit]
  def listFilters(
      request: zio.aws.personalize.model.ListFiltersRequest
  ): ZStream[Any, AwsError, zio.aws.personalize.model.FilterSummary.ReadOnly]
  def listFiltersPaginated(
      request: zio.aws.personalize.model.ListFiltersRequest
  ): IO[AwsError, zio.aws.personalize.model.ListFiltersResponse.ReadOnly]
  def describeDatasetGroup(
      request: zio.aws.personalize.model.DescribeDatasetGroupRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeDatasetGroupResponse.ReadOnly
  ]
  def describeEventTracker(
      request: zio.aws.personalize.model.DescribeEventTrackerRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeEventTrackerResponse.ReadOnly
  ]
  def listRecommenders(
      request: zio.aws.personalize.model.ListRecommendersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.RecommenderSummary.ReadOnly
  ]
  def listRecommendersPaginated(
      request: zio.aws.personalize.model.ListRecommendersRequest
  ): IO[AwsError, zio.aws.personalize.model.ListRecommendersResponse.ReadOnly]
  def listDatasets(
      request: zio.aws.personalize.model.ListDatasetsRequest
  ): ZStream[Any, AwsError, zio.aws.personalize.model.DatasetSummary.ReadOnly]
  def listDatasetsPaginated(
      request: zio.aws.personalize.model.ListDatasetsRequest
  ): IO[AwsError, zio.aws.personalize.model.ListDatasetsResponse.ReadOnly]
  def describeSolutionVersion(
      request: zio.aws.personalize.model.DescribeSolutionVersionRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeSolutionVersionResponse.ReadOnly
  ]
  def createCampaign(
      request: zio.aws.personalize.model.CreateCampaignRequest
  ): IO[AwsError, zio.aws.personalize.model.CreateCampaignResponse.ReadOnly]
  def deleteEventTracker(
      request: zio.aws.personalize.model.DeleteEventTrackerRequest
  ): IO[AwsError, Unit]
  def listDatasetImportJobs(
      request: zio.aws.personalize.model.ListDatasetImportJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly
  ]
  def listDatasetImportJobsPaginated(
      request: zio.aws.personalize.model.ListDatasetImportJobsRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.ListDatasetImportJobsResponse.ReadOnly
  ]
  def listBatchInferenceJobs(
      request: zio.aws.personalize.model.ListBatchInferenceJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly
  ]
  def listBatchInferenceJobsPaginated(
      request: zio.aws.personalize.model.ListBatchInferenceJobsRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.ListBatchInferenceJobsResponse.ReadOnly
  ]
  def createSchema(
      request: zio.aws.personalize.model.CreateSchemaRequest
  ): IO[AwsError, zio.aws.personalize.model.CreateSchemaResponse.ReadOnly]
  def listBatchSegmentJobs(
      request: zio.aws.personalize.model.ListBatchSegmentJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly
  ]
  def listBatchSegmentJobsPaginated(
      request: zio.aws.personalize.model.ListBatchSegmentJobsRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.ListBatchSegmentJobsResponse.ReadOnly
  ]
  def describeFilter(
      request: zio.aws.personalize.model.DescribeFilterRequest
  ): IO[AwsError, zio.aws.personalize.model.DescribeFilterResponse.ReadOnly]
  def listDatasetExportJobs(
      request: zio.aws.personalize.model.ListDatasetExportJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly
  ]
  def listDatasetExportJobsPaginated(
      request: zio.aws.personalize.model.ListDatasetExportJobsRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.ListDatasetExportJobsResponse.ReadOnly
  ]
  def describeFeatureTransformation(
      request: zio.aws.personalize.model.DescribeFeatureTransformationRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeFeatureTransformationResponse.ReadOnly
  ]
  def deleteSchema(
      request: zio.aws.personalize.model.DeleteSchemaRequest
  ): IO[AwsError, Unit]
  def deleteDataset(
      request: zio.aws.personalize.model.DeleteDatasetRequest
  ): IO[AwsError, Unit]
  def listSolutionVersions(
      request: zio.aws.personalize.model.ListSolutionVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
  ]
  def listSolutionVersionsPaginated(
      request: zio.aws.personalize.model.ListSolutionVersionsRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly
  ]
  def describeRecommender(
      request: zio.aws.personalize.model.DescribeRecommenderRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.DescribeRecommenderResponse.ReadOnly
  ]
  def listSchemas(
      request: zio.aws.personalize.model.ListSchemasRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly
  ]
  def listSchemasPaginated(
      request: zio.aws.personalize.model.ListSchemasRequest
  ): IO[AwsError, zio.aws.personalize.model.ListSchemasResponse.ReadOnly]
  def createBatchSegmentJob(
      request: zio.aws.personalize.model.CreateBatchSegmentJobRequest
  ): IO[
    AwsError,
    zio.aws.personalize.model.CreateBatchSegmentJobResponse.ReadOnly
  ]
  def listRecipes(
      request: zio.aws.personalize.model.ListRecipesRequest
  ): ZStream[Any, AwsError, zio.aws.personalize.model.RecipeSummary.ReadOnly]
  def listRecipesPaginated(
      request: zio.aws.personalize.model.ListRecipesRequest
  ): IO[AwsError, zio.aws.personalize.model.ListRecipesResponse.ReadOnly]
  def updateCampaign(
      request: zio.aws.personalize.model.UpdateCampaignRequest
  ): IO[AwsError, zio.aws.personalize.model.UpdateCampaignResponse.ReadOnly]
}
object Personalize {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Personalize] = customized(
    identity
  )
  def customized(
      customization: PersonalizeAsyncClientBuilder => PersonalizeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Personalize] = managed(
    customization
  ).toLayer
  def managed(
      customization: PersonalizeAsyncClientBuilder => PersonalizeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Personalize] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = PersonalizeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[PersonalizeAsyncClient, PersonalizeAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        PersonalizeAsyncClient,
        PersonalizeAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new PersonalizeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class PersonalizeImpl[R](
      override val api: PersonalizeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Personalize
      with AwsServiceBase[R] {
    override val serviceName: String = "Personalize"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PersonalizeImpl[R1] = new PersonalizeImpl(api, newAspect, r)
    def getSolutionMetrics(
        request: zio.aws.personalize.model.GetSolutionMetricsRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.GetSolutionMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSolutionMetricsRequest,
      GetSolutionMetricsResponse
    ]("getSolutionMetrics", api.getSolutionMetrics)(request.buildAwsValue())
      .map(zio.aws.personalize.model.GetSolutionMetricsResponse.wrap)
      .provideEnvironment(r)
    def createDataset(
        request: zio.aws.personalize.model.CreateDatasetRequest
    ): IO[AwsError, zio.aws.personalize.model.CreateDatasetResponse.ReadOnly] =
      asyncRequestResponse[CreateDatasetRequest, CreateDatasetResponse](
        "createDataset",
        api.createDataset
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.CreateDatasetResponse.wrap)
        .provideEnvironment(r)
    def createEventTracker(
        request: zio.aws.personalize.model.CreateEventTrackerRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEventTrackerRequest,
      CreateEventTrackerResponse
    ]("createEventTracker", api.createEventTracker)(request.buildAwsValue())
      .map(zio.aws.personalize.model.CreateEventTrackerResponse.wrap)
      .provideEnvironment(r)
    def deleteCampaign(
        request: zio.aws.personalize.model.DeleteCampaignRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteCampaignRequest, DeleteCampaignResponse](
        "deleteCampaign",
        api.deleteCampaign
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeAlgorithm(
        request: zio.aws.personalize.model.DescribeAlgorithmRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeAlgorithmResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeAlgorithmRequest, DescribeAlgorithmResponse](
        "describeAlgorithm",
        api.describeAlgorithm
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.DescribeAlgorithmResponse.wrap)
        .provideEnvironment(r)
    def describeDatasetExportJob(
        request: zio.aws.personalize.model.DescribeDatasetExportJobRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeDatasetExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDatasetExportJobRequest,
      DescribeDatasetExportJobResponse
    ]("describeDatasetExportJob", api.describeDatasetExportJob)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.DescribeDatasetExportJobResponse.wrap)
      .provideEnvironment(r)
    def listCampaigns(
        request: zio.aws.personalize.model.ListCampaignsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.CampaignSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListCampaignsRequest,
      CampaignSummary,
      ListCampaignsPublisher
    ]("listCampaigns", api.listCampaignsPaginator, _.campaigns())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.CampaignSummary.wrap(item))
      .provideEnvironment(r)
    def listCampaignsPaginated(
        request: zio.aws.personalize.model.ListCampaignsRequest
    ): IO[AwsError, zio.aws.personalize.model.ListCampaignsResponse.ReadOnly] =
      asyncRequestResponse[ListCampaignsRequest, ListCampaignsResponse](
        "listCampaigns",
        api.listCampaigns
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.ListCampaignsResponse.wrap)
        .provideEnvironment(r)
    def createDatasetGroup(
        request: zio.aws.personalize.model.CreateDatasetGroupRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.CreateDatasetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDatasetGroupRequest,
      CreateDatasetGroupResponse
    ]("createDatasetGroup", api.createDatasetGroup)(request.buildAwsValue())
      .map(zio.aws.personalize.model.CreateDatasetGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteFilter(
        request: zio.aws.personalize.model.DeleteFilterRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteFilterRequest, DeleteFilterResponse](
        "deleteFilter",
        api.deleteFilter
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteRecommender(
        request: zio.aws.personalize.model.DeleteRecommenderRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRecommenderRequest, DeleteRecommenderResponse](
        "deleteRecommender",
        api.deleteRecommender
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createSolution(
        request: zio.aws.personalize.model.CreateSolutionRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateSolutionRequest, CreateSolutionResponse](
        "createSolution",
        api.createSolution
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.CreateSolutionResponse.wrap)
        .provideEnvironment(r)
    def describeBatchSegmentJob(
        request: zio.aws.personalize.model.DescribeBatchSegmentJobRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeBatchSegmentJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeBatchSegmentJobRequest,
      DescribeBatchSegmentJobResponse
    ]("describeBatchSegmentJob", api.describeBatchSegmentJob)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.DescribeBatchSegmentJobResponse.wrap)
      .provideEnvironment(r)
    def createRecommender(
        request: zio.aws.personalize.model.CreateRecommenderRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.CreateRecommenderResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateRecommenderRequest, CreateRecommenderResponse](
        "createRecommender",
        api.createRecommender
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.CreateRecommenderResponse.wrap)
        .provideEnvironment(r)
    def describeBatchInferenceJob(
        request: zio.aws.personalize.model.DescribeBatchInferenceJobRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeBatchInferenceJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeBatchInferenceJobRequest,
      DescribeBatchInferenceJobResponse
    ]("describeBatchInferenceJob", api.describeBatchInferenceJob)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.DescribeBatchInferenceJobResponse.wrap)
      .provideEnvironment(r)
    def describeCampaign(
        request: zio.aws.personalize.model.DescribeCampaignRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeCampaignResponse.ReadOnly
    ] = asyncRequestResponse[DescribeCampaignRequest, DescribeCampaignResponse](
      "describeCampaign",
      api.describeCampaign
    )(request.buildAwsValue())
      .map(zio.aws.personalize.model.DescribeCampaignResponse.wrap)
      .provideEnvironment(r)
    def createFilter(
        request: zio.aws.personalize.model.CreateFilterRequest
    ): IO[AwsError, zio.aws.personalize.model.CreateFilterResponse.ReadOnly] =
      asyncRequestResponse[CreateFilterRequest, CreateFilterResponse](
        "createFilter",
        api.createFilter
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.CreateFilterResponse.wrap)
        .provideEnvironment(r)
    def listSolutions(
        request: zio.aws.personalize.model.ListSolutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSolutionsRequest,
      SolutionSummary,
      ListSolutionsPublisher
    ]("listSolutions", api.listSolutionsPaginator, _.solutions())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.SolutionSummary.wrap(item))
      .provideEnvironment(r)
    def listSolutionsPaginated(
        request: zio.aws.personalize.model.ListSolutionsRequest
    ): IO[AwsError, zio.aws.personalize.model.ListSolutionsResponse.ReadOnly] =
      asyncRequestResponse[ListSolutionsRequest, ListSolutionsResponse](
        "listSolutions",
        api.listSolutions
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.ListSolutionsResponse.wrap)
        .provideEnvironment(r)
    def describeDatasetImportJob(
        request: zio.aws.personalize.model.DescribeDatasetImportJobRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeDatasetImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDatasetImportJobRequest,
      DescribeDatasetImportJobResponse
    ]("describeDatasetImportJob", api.describeDatasetImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.DescribeDatasetImportJobResponse.wrap)
      .provideEnvironment(r)
    def describeSolution(
        request: zio.aws.personalize.model.DescribeSolutionRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly
    ] = asyncRequestResponse[DescribeSolutionRequest, DescribeSolutionResponse](
      "describeSolution",
      api.describeSolution
    )(request.buildAwsValue())
      .map(zio.aws.personalize.model.DescribeSolutionResponse.wrap)
      .provideEnvironment(r)
    def listEventTrackers(
        request: zio.aws.personalize.model.ListEventTrackersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.EventTrackerSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListEventTrackersRequest,
      EventTrackerSummary,
      ListEventTrackersPublisher
    ]("listEventTrackers", api.listEventTrackersPaginator, _.eventTrackers())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.EventTrackerSummary.wrap(item))
      .provideEnvironment(r)
    def listEventTrackersPaginated(
        request: zio.aws.personalize.model.ListEventTrackersRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly
    ] =
      asyncRequestResponse[ListEventTrackersRequest, ListEventTrackersResponse](
        "listEventTrackers",
        api.listEventTrackers
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.ListEventTrackersResponse.wrap)
        .provideEnvironment(r)
    def describeDataset(
        request: zio.aws.personalize.model.DescribeDatasetRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeDatasetResponse.ReadOnly
    ] = asyncRequestResponse[DescribeDatasetRequest, DescribeDatasetResponse](
      "describeDataset",
      api.describeDataset
    )(request.buildAwsValue())
      .map(zio.aws.personalize.model.DescribeDatasetResponse.wrap)
      .provideEnvironment(r)
    def createDatasetImportJob(
        request: zio.aws.personalize.model.CreateDatasetImportJobRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.CreateDatasetImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDatasetImportJobRequest,
      CreateDatasetImportJobResponse
    ]("createDatasetImportJob", api.createDatasetImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.CreateDatasetImportJobResponse.wrap)
      .provideEnvironment(r)
    def describeSchema(
        request: zio.aws.personalize.model.DescribeSchemaRequest
    ): IO[AwsError, zio.aws.personalize.model.DescribeSchemaResponse.ReadOnly] =
      asyncRequestResponse[DescribeSchemaRequest, DescribeSchemaResponse](
        "describeSchema",
        api.describeSchema
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.DescribeSchemaResponse.wrap)
        .provideEnvironment(r)
    def createSolutionVersion(
        request: zio.aws.personalize.model.CreateSolutionVersionRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.CreateSolutionVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSolutionVersionRequest,
      CreateSolutionVersionResponse
    ]("createSolutionVersion", api.createSolutionVersion)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.CreateSolutionVersionResponse.wrap)
      .provideEnvironment(r)
    def createDatasetExportJob(
        request: zio.aws.personalize.model.CreateDatasetExportJobRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.CreateDatasetExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDatasetExportJobRequest,
      CreateDatasetExportJobResponse
    ]("createDatasetExportJob", api.createDatasetExportJob)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.CreateDatasetExportJobResponse.wrap)
      .provideEnvironment(r)
    def describeRecipe(
        request: zio.aws.personalize.model.DescribeRecipeRequest
    ): IO[AwsError, zio.aws.personalize.model.DescribeRecipeResponse.ReadOnly] =
      asyncRequestResponse[DescribeRecipeRequest, DescribeRecipeResponse](
        "describeRecipe",
        api.describeRecipe
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.DescribeRecipeResponse.wrap)
        .provideEnvironment(r)
    def deleteSolution(
        request: zio.aws.personalize.model.DeleteSolutionRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteSolutionRequest, DeleteSolutionResponse](
        "deleteSolution",
        api.deleteSolution
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateRecommender(
        request: zio.aws.personalize.model.UpdateRecommenderRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.UpdateRecommenderResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateRecommenderRequest, UpdateRecommenderResponse](
        "updateRecommender",
        api.updateRecommender
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.UpdateRecommenderResponse.wrap)
        .provideEnvironment(r)
    def deleteDatasetGroup(
        request: zio.aws.personalize.model.DeleteDatasetGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDatasetGroupRequest,
      DeleteDatasetGroupResponse
    ]("deleteDatasetGroup", api.deleteDatasetGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listDatasetGroups(
        request: zio.aws.personalize.model.ListDatasetGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetGroupSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDatasetGroupsRequest,
      DatasetGroupSummary,
      ListDatasetGroupsPublisher
    ]("listDatasetGroups", api.listDatasetGroupsPaginator, _.datasetGroups())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.DatasetGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listDatasetGroupsPaginated(
        request: zio.aws.personalize.model.ListDatasetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.ListDatasetGroupsResponse.ReadOnly
    ] =
      asyncRequestResponse[ListDatasetGroupsRequest, ListDatasetGroupsResponse](
        "listDatasetGroups",
        api.listDatasetGroups
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.ListDatasetGroupsResponse.wrap)
        .provideEnvironment(r)
    def createBatchInferenceJob(
        request: zio.aws.personalize.model.CreateBatchInferenceJobRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.CreateBatchInferenceJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateBatchInferenceJobRequest,
      CreateBatchInferenceJobResponse
    ]("createBatchInferenceJob", api.createBatchInferenceJob)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.CreateBatchInferenceJobResponse.wrap)
      .provideEnvironment(r)
    def stopSolutionVersionCreation(
        request: zio.aws.personalize.model.StopSolutionVersionCreationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StopSolutionVersionCreationRequest,
      StopSolutionVersionCreationResponse
    ]("stopSolutionVersionCreation", api.stopSolutionVersionCreation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listFilters(
        request: zio.aws.personalize.model.ListFiltersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.FilterSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListFiltersRequest,
      FilterSummary,
      ListFiltersPublisher
    ]("listFilters", api.listFiltersPaginator, _.filters())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.FilterSummary.wrap(item))
      .provideEnvironment(r)
    def listFiltersPaginated(
        request: zio.aws.personalize.model.ListFiltersRequest
    ): IO[AwsError, zio.aws.personalize.model.ListFiltersResponse.ReadOnly] =
      asyncRequestResponse[ListFiltersRequest, ListFiltersResponse](
        "listFilters",
        api.listFilters
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.ListFiltersResponse.wrap)
        .provideEnvironment(r)
    def describeDatasetGroup(
        request: zio.aws.personalize.model.DescribeDatasetGroupRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeDatasetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDatasetGroupRequest,
      DescribeDatasetGroupResponse
    ]("describeDatasetGroup", api.describeDatasetGroup)(request.buildAwsValue())
      .map(zio.aws.personalize.model.DescribeDatasetGroupResponse.wrap)
      .provideEnvironment(r)
    def describeEventTracker(
        request: zio.aws.personalize.model.DescribeEventTrackerRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeEventTrackerResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEventTrackerRequest,
      DescribeEventTrackerResponse
    ]("describeEventTracker", api.describeEventTracker)(request.buildAwsValue())
      .map(zio.aws.personalize.model.DescribeEventTrackerResponse.wrap)
      .provideEnvironment(r)
    def listRecommenders(
        request: zio.aws.personalize.model.ListRecommendersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListRecommendersRequest,
      RecommenderSummary,
      ListRecommendersPublisher
    ]("listRecommenders", api.listRecommendersPaginator, _.recommenders())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.RecommenderSummary.wrap(item))
      .provideEnvironment(r)
    def listRecommendersPaginated(
        request: zio.aws.personalize.model.ListRecommendersRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.ListRecommendersResponse.ReadOnly
    ] = asyncRequestResponse[ListRecommendersRequest, ListRecommendersResponse](
      "listRecommenders",
      api.listRecommenders
    )(request.buildAwsValue())
      .map(zio.aws.personalize.model.ListRecommendersResponse.wrap)
      .provideEnvironment(r)
    def listDatasets(
        request: zio.aws.personalize.model.ListDatasetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDatasetsRequest,
      DatasetSummary,
      ListDatasetsPublisher
    ]("listDatasets", api.listDatasetsPaginator, _.datasets())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.DatasetSummary.wrap(item))
      .provideEnvironment(r)
    def listDatasetsPaginated(
        request: zio.aws.personalize.model.ListDatasetsRequest
    ): IO[AwsError, zio.aws.personalize.model.ListDatasetsResponse.ReadOnly] =
      asyncRequestResponse[ListDatasetsRequest, ListDatasetsResponse](
        "listDatasets",
        api.listDatasets
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.ListDatasetsResponse.wrap)
        .provideEnvironment(r)
    def describeSolutionVersion(
        request: zio.aws.personalize.model.DescribeSolutionVersionRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeSolutionVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSolutionVersionRequest,
      DescribeSolutionVersionResponse
    ]("describeSolutionVersion", api.describeSolutionVersion)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.DescribeSolutionVersionResponse.wrap)
      .provideEnvironment(r)
    def createCampaign(
        request: zio.aws.personalize.model.CreateCampaignRequest
    ): IO[AwsError, zio.aws.personalize.model.CreateCampaignResponse.ReadOnly] =
      asyncRequestResponse[CreateCampaignRequest, CreateCampaignResponse](
        "createCampaign",
        api.createCampaign
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.CreateCampaignResponse.wrap)
        .provideEnvironment(r)
    def deleteEventTracker(
        request: zio.aws.personalize.model.DeleteEventTrackerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteEventTrackerRequest,
      DeleteEventTrackerResponse
    ]("deleteEventTracker", api.deleteEventTracker)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listDatasetImportJobs(
        request: zio.aws.personalize.model.ListDatasetImportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDatasetImportJobsRequest,
      DatasetImportJobSummary,
      ListDatasetImportJobsPublisher
    ](
      "listDatasetImportJobs",
      api.listDatasetImportJobsPaginator,
      _.datasetImportJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.personalize.model.DatasetImportJobSummary.wrap(item))
      .provideEnvironment(r)
    def listDatasetImportJobsPaginated(
        request: zio.aws.personalize.model.ListDatasetImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.ListDatasetImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDatasetImportJobsRequest,
      ListDatasetImportJobsResponse
    ]("listDatasetImportJobs", api.listDatasetImportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.ListDatasetImportJobsResponse.wrap)
      .provideEnvironment(r)
    def listBatchInferenceJobs(
        request: zio.aws.personalize.model.ListBatchInferenceJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListBatchInferenceJobsRequest,
      BatchInferenceJobSummary,
      ListBatchInferenceJobsPublisher
    ](
      "listBatchInferenceJobs",
      api.listBatchInferenceJobsPaginator,
      _.batchInferenceJobs()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.personalize.model.BatchInferenceJobSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listBatchInferenceJobsPaginated(
        request: zio.aws.personalize.model.ListBatchInferenceJobsRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.ListBatchInferenceJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBatchInferenceJobsRequest,
      ListBatchInferenceJobsResponse
    ]("listBatchInferenceJobs", api.listBatchInferenceJobs)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.ListBatchInferenceJobsResponse.wrap)
      .provideEnvironment(r)
    def createSchema(
        request: zio.aws.personalize.model.CreateSchemaRequest
    ): IO[AwsError, zio.aws.personalize.model.CreateSchemaResponse.ReadOnly] =
      asyncRequestResponse[CreateSchemaRequest, CreateSchemaResponse](
        "createSchema",
        api.createSchema
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.CreateSchemaResponse.wrap)
        .provideEnvironment(r)
    def listBatchSegmentJobs(
        request: zio.aws.personalize.model.ListBatchSegmentJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListBatchSegmentJobsRequest,
      BatchSegmentJobSummary,
      ListBatchSegmentJobsPublisher
    ](
      "listBatchSegmentJobs",
      api.listBatchSegmentJobsPaginator,
      _.batchSegmentJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.personalize.model.BatchSegmentJobSummary.wrap(item))
      .provideEnvironment(r)
    def listBatchSegmentJobsPaginated(
        request: zio.aws.personalize.model.ListBatchSegmentJobsRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.ListBatchSegmentJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBatchSegmentJobsRequest,
      ListBatchSegmentJobsResponse
    ]("listBatchSegmentJobs", api.listBatchSegmentJobs)(request.buildAwsValue())
      .map(zio.aws.personalize.model.ListBatchSegmentJobsResponse.wrap)
      .provideEnvironment(r)
    def describeFilter(
        request: zio.aws.personalize.model.DescribeFilterRequest
    ): IO[AwsError, zio.aws.personalize.model.DescribeFilterResponse.ReadOnly] =
      asyncRequestResponse[DescribeFilterRequest, DescribeFilterResponse](
        "describeFilter",
        api.describeFilter
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.DescribeFilterResponse.wrap)
        .provideEnvironment(r)
    def listDatasetExportJobs(
        request: zio.aws.personalize.model.ListDatasetExportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDatasetExportJobsRequest,
      DatasetExportJobSummary,
      ListDatasetExportJobsPublisher
    ](
      "listDatasetExportJobs",
      api.listDatasetExportJobsPaginator,
      _.datasetExportJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.personalize.model.DatasetExportJobSummary.wrap(item))
      .provideEnvironment(r)
    def listDatasetExportJobsPaginated(
        request: zio.aws.personalize.model.ListDatasetExportJobsRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.ListDatasetExportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDatasetExportJobsRequest,
      ListDatasetExportJobsResponse
    ]("listDatasetExportJobs", api.listDatasetExportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.ListDatasetExportJobsResponse.wrap)
      .provideEnvironment(r)
    def describeFeatureTransformation(
        request: zio.aws.personalize.model.DescribeFeatureTransformationRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeFeatureTransformationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFeatureTransformationRequest,
      DescribeFeatureTransformationResponse
    ]("describeFeatureTransformation", api.describeFeatureTransformation)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.DescribeFeatureTransformationResponse.wrap)
      .provideEnvironment(r)
    def deleteSchema(
        request: zio.aws.personalize.model.DeleteSchemaRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteSchemaRequest, DeleteSchemaResponse](
        "deleteSchema",
        api.deleteSchema
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteDataset(
        request: zio.aws.personalize.model.DeleteDatasetRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDatasetRequest, DeleteDatasetResponse](
        "deleteDataset",
        api.deleteDataset
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listSolutionVersions(
        request: zio.aws.personalize.model.ListSolutionVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSolutionVersionsRequest,
      SolutionVersionSummary,
      ListSolutionVersionsPublisher
    ](
      "listSolutionVersions",
      api.listSolutionVersionsPaginator,
      _.solutionVersions()
    )(request.buildAwsValue())
      .map(item => zio.aws.personalize.model.SolutionVersionSummary.wrap(item))
      .provideEnvironment(r)
    def listSolutionVersionsPaginated(
        request: zio.aws.personalize.model.ListSolutionVersionsRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSolutionVersionsRequest,
      ListSolutionVersionsResponse
    ]("listSolutionVersions", api.listSolutionVersions)(request.buildAwsValue())
      .map(zio.aws.personalize.model.ListSolutionVersionsResponse.wrap)
      .provideEnvironment(r)
    def describeRecommender(
        request: zio.aws.personalize.model.DescribeRecommenderRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.DescribeRecommenderResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRecommenderRequest,
      DescribeRecommenderResponse
    ]("describeRecommender", api.describeRecommender)(request.buildAwsValue())
      .map(zio.aws.personalize.model.DescribeRecommenderResponse.wrap)
      .provideEnvironment(r)
    def listSchemas(
        request: zio.aws.personalize.model.ListSchemasRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSchemasRequest,
      DatasetSchemaSummary,
      ListSchemasPublisher
    ]("listSchemas", api.listSchemasPaginator, _.schemas())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.DatasetSchemaSummary.wrap(item))
      .provideEnvironment(r)
    def listSchemasPaginated(
        request: zio.aws.personalize.model.ListSchemasRequest
    ): IO[AwsError, zio.aws.personalize.model.ListSchemasResponse.ReadOnly] =
      asyncRequestResponse[ListSchemasRequest, ListSchemasResponse](
        "listSchemas",
        api.listSchemas
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.ListSchemasResponse.wrap)
        .provideEnvironment(r)
    def createBatchSegmentJob(
        request: zio.aws.personalize.model.CreateBatchSegmentJobRequest
    ): IO[
      AwsError,
      zio.aws.personalize.model.CreateBatchSegmentJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateBatchSegmentJobRequest,
      CreateBatchSegmentJobResponse
    ]("createBatchSegmentJob", api.createBatchSegmentJob)(
      request.buildAwsValue()
    ).map(zio.aws.personalize.model.CreateBatchSegmentJobResponse.wrap)
      .provideEnvironment(r)
    def listRecipes(
        request: zio.aws.personalize.model.ListRecipesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.personalize.model.RecipeSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListRecipesRequest,
      RecipeSummary,
      ListRecipesPublisher
    ]("listRecipes", api.listRecipesPaginator, _.recipes())(
      request.buildAwsValue()
    ).map(item => zio.aws.personalize.model.RecipeSummary.wrap(item))
      .provideEnvironment(r)
    def listRecipesPaginated(
        request: zio.aws.personalize.model.ListRecipesRequest
    ): IO[AwsError, zio.aws.personalize.model.ListRecipesResponse.ReadOnly] =
      asyncRequestResponse[ListRecipesRequest, ListRecipesResponse](
        "listRecipes",
        api.listRecipes
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.ListRecipesResponse.wrap)
        .provideEnvironment(r)
    def updateCampaign(
        request: zio.aws.personalize.model.UpdateCampaignRequest
    ): IO[AwsError, zio.aws.personalize.model.UpdateCampaignResponse.ReadOnly] =
      asyncRequestResponse[UpdateCampaignRequest, UpdateCampaignResponse](
        "updateCampaign",
        api.updateCampaign
      )(request.buildAwsValue())
        .map(zio.aws.personalize.model.UpdateCampaignResponse.wrap)
        .provideEnvironment(r)
  }
  def getSolutionMetrics(
      request: zio.aws.personalize.model.GetSolutionMetricsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.GetSolutionMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSolutionMetrics(request))
  def createDataset(
      request: zio.aws.personalize.model.CreateDatasetRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def createEventTracker(
      request: zio.aws.personalize.model.CreateEventTrackerRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventTracker(request))
  def deleteCampaign(
      request: zio.aws.personalize.model.DeleteCampaignRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCampaign(request))
  def describeAlgorithm(
      request: zio.aws.personalize.model.DescribeAlgorithmRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeAlgorithmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAlgorithm(request))
  def describeDatasetExportJob(
      request: zio.aws.personalize.model.DescribeDatasetExportJobRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeDatasetExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDatasetExportJob(request))
  def listCampaigns(
      request: zio.aws.personalize.model.ListCampaignsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CampaignSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCampaigns(request))
  def listCampaignsPaginated(
      request: zio.aws.personalize.model.ListCampaignsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListCampaignsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCampaignsPaginated(request))
  def createDatasetGroup(
      request: zio.aws.personalize.model.CreateDatasetGroupRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateDatasetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatasetGroup(request))
  def deleteFilter(
      request: zio.aws.personalize.model.DeleteFilterRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFilter(request))
  def deleteRecommender(
      request: zio.aws.personalize.model.DeleteRecommenderRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRecommender(request))
  def createSolution(
      request: zio.aws.personalize.model.CreateSolutionRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createSolution(request))
  def describeBatchSegmentJob(
      request: zio.aws.personalize.model.DescribeBatchSegmentJobRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeBatchSegmentJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBatchSegmentJob(request))
  def createRecommender(
      request: zio.aws.personalize.model.CreateRecommenderRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateRecommenderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRecommender(request))
  def describeBatchInferenceJob(
      request: zio.aws.personalize.model.DescribeBatchInferenceJobRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeBatchInferenceJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBatchInferenceJob(request))
  def describeCampaign(
      request: zio.aws.personalize.model.DescribeCampaignRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCampaign(request))
  def createFilter(request: zio.aws.personalize.model.CreateFilterRequest): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFilter(request))
  def listSolutions(
      request: zio.aws.personalize.model.ListSolutionsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.SolutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSolutions(request))
  def listSolutionsPaginated(
      request: zio.aws.personalize.model.ListSolutionsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListSolutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSolutionsPaginated(request))
  def describeDatasetImportJob(
      request: zio.aws.personalize.model.DescribeDatasetImportJobRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeDatasetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDatasetImportJob(request))
  def describeSolution(
      request: zio.aws.personalize.model.DescribeSolutionRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSolution(request))
  def listEventTrackers(
      request: zio.aws.personalize.model.ListEventTrackersRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.EventTrackerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventTrackers(request))
  def listEventTrackersPaginated(
      request: zio.aws.personalize.model.ListEventTrackersRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventTrackersPaginated(request))
  def describeDataset(
      request: zio.aws.personalize.model.DescribeDatasetRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def createDatasetImportJob(
      request: zio.aws.personalize.model.CreateDatasetImportJobRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateDatasetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatasetImportJob(request))
  def describeSchema(
      request: zio.aws.personalize.model.DescribeSchemaRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSchema(request))
  def createSolutionVersion(
      request: zio.aws.personalize.model.CreateSolutionVersionRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateSolutionVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSolutionVersion(request))
  def createDatasetExportJob(
      request: zio.aws.personalize.model.CreateDatasetExportJobRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateDatasetExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatasetExportJob(request))
  def describeRecipe(
      request: zio.aws.personalize.model.DescribeRecipeRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecipe(request))
  def deleteSolution(
      request: zio.aws.personalize.model.DeleteSolutionRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSolution(request))
  def updateRecommender(
      request: zio.aws.personalize.model.UpdateRecommenderRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.UpdateRecommenderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRecommender(request))
  def deleteDatasetGroup(
      request: zio.aws.personalize.model.DeleteDatasetGroupRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDatasetGroup(request))
  def listDatasetGroups(
      request: zio.aws.personalize.model.ListDatasetGroupsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DatasetGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasetGroups(request))
  def listDatasetGroupsPaginated(
      request: zio.aws.personalize.model.ListDatasetGroupsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListDatasetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetGroupsPaginated(request))
  def createBatchInferenceJob(
      request: zio.aws.personalize.model.CreateBatchInferenceJobRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateBatchInferenceJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBatchInferenceJob(request))
  def stopSolutionVersionCreation(
      request: zio.aws.personalize.model.StopSolutionVersionCreationRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopSolutionVersionCreation(request))
  def listFilters(
      request: zio.aws.personalize.model.ListFiltersRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.FilterSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFilters(request))
  def listFiltersPaginated(
      request: zio.aws.personalize.model.ListFiltersRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListFiltersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFiltersPaginated(request))
  def describeDatasetGroup(
      request: zio.aws.personalize.model.DescribeDatasetGroupRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeDatasetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDatasetGroup(request))
  def describeEventTracker(
      request: zio.aws.personalize.model.DescribeEventTrackerRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeEventTrackerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventTracker(request))
  def listRecommenders(
      request: zio.aws.personalize.model.ListRecommendersRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.RecommenderSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecommenders(request))
  def listRecommendersPaginated(
      request: zio.aws.personalize.model.ListRecommendersRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListRecommendersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecommendersPaginated(request))
  def listDatasets(
      request: zio.aws.personalize.model.ListDatasetsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DatasetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasets(request))
  def listDatasetsPaginated(
      request: zio.aws.personalize.model.ListDatasetsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetsPaginated(request))
  def describeSolutionVersion(
      request: zio.aws.personalize.model.DescribeSolutionVersionRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeSolutionVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSolutionVersion(request))
  def createCampaign(
      request: zio.aws.personalize.model.CreateCampaignRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCampaign(request))
  def deleteEventTracker(
      request: zio.aws.personalize.model.DeleteEventTrackerRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEventTracker(request))
  def listDatasetImportJobs(
      request: zio.aws.personalize.model.ListDatasetImportJobsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasetImportJobs(request))
  def listDatasetImportJobsPaginated(
      request: zio.aws.personalize.model.ListDatasetImportJobsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListDatasetImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetImportJobsPaginated(request))
  def listBatchInferenceJobs(
      request: zio.aws.personalize.model.ListBatchInferenceJobsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listBatchInferenceJobs(request))
  def listBatchInferenceJobsPaginated(
      request: zio.aws.personalize.model.ListBatchInferenceJobsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListBatchInferenceJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBatchInferenceJobsPaginated(request))
  def createSchema(request: zio.aws.personalize.model.CreateSchemaRequest): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSchema(request))
  def listBatchSegmentJobs(
      request: zio.aws.personalize.model.ListBatchSegmentJobsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listBatchSegmentJobs(request))
  def listBatchSegmentJobsPaginated(
      request: zio.aws.personalize.model.ListBatchSegmentJobsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListBatchSegmentJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBatchSegmentJobsPaginated(request))
  def describeFilter(
      request: zio.aws.personalize.model.DescribeFilterRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFilter(request))
  def listDatasetExportJobs(
      request: zio.aws.personalize.model.ListDatasetExportJobsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasetExportJobs(request))
  def listDatasetExportJobsPaginated(
      request: zio.aws.personalize.model.ListDatasetExportJobsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListDatasetExportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetExportJobsPaginated(request))
  def describeFeatureTransformation(
      request: zio.aws.personalize.model.DescribeFeatureTransformationRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeFeatureTransformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFeatureTransformation(request))
  def deleteSchema(
      request: zio.aws.personalize.model.DeleteSchemaRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSchema(request))
  def deleteDataset(
      request: zio.aws.personalize.model.DeleteDatasetRequest
  ): ZIO[zio.aws.personalize.Personalize, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDataset(request))
  def listSolutionVersions(
      request: zio.aws.personalize.model.ListSolutionVersionsRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSolutionVersions(request))
  def listSolutionVersionsPaginated(
      request: zio.aws.personalize.model.ListSolutionVersionsRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSolutionVersionsPaginated(request))
  def describeRecommender(
      request: zio.aws.personalize.model.DescribeRecommenderRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DescribeRecommenderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecommender(request))
  def listSchemas(
      request: zio.aws.personalize.model.ListSchemasRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSchemas(request))
  def listSchemasPaginated(
      request: zio.aws.personalize.model.ListSchemasRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSchemasPaginated(request))
  def createBatchSegmentJob(
      request: zio.aws.personalize.model.CreateBatchSegmentJobRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.CreateBatchSegmentJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBatchSegmentJob(request))
  def listRecipes(
      request: zio.aws.personalize.model.ListRecipesRequest
  ): ZStream[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.RecipeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecipes(request))
  def listRecipesPaginated(
      request: zio.aws.personalize.model.ListRecipesRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.ListRecipesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecipesPaginated(request))
  def updateCampaign(
      request: zio.aws.personalize.model.UpdateCampaignRequest
  ): ZIO[
    zio.aws.personalize.Personalize,
    AwsError,
    zio.aws.personalize.model.UpdateCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCampaign(request))
}
