package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{ParameterValue, ParameterName}
import scala.jdk.CollectionConverters.*
final case class BatchInferenceJobConfig(
    itemExplorationConfig: Option[Map[ParameterName, ParameterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchInferenceJobConfig = {
    import BatchInferenceJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchInferenceJobConfig
      .builder()
      .optionallyWith(
        itemExplorationConfig.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.itemExplorationConfig)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly =
    zio.aws.personalize.model.BatchInferenceJobConfig.wrap(buildAwsValue())
}
object BatchInferenceJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchInferenceJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchInferenceJobConfig =
      zio.aws.personalize.model
        .BatchInferenceJobConfig(itemExplorationConfig.map(value => value))
    def itemExplorationConfig: Option[Map[ParameterName, ParameterValue]]
    def getItemExplorationConfig
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField("itemExplorationConfig", itemExplorationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchInferenceJobConfig
  ) extends zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly {
    override val itemExplorationConfig
        : Option[Map[ParameterName, ParameterValue]] = scala
      .Option(impl.itemExplorationConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchInferenceJobConfig
  ): zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly = new Wrapper(
    impl
  )
}
