package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchInferenceJobInput(
    s3DataSource: zio.aws.personalize.model.S3DataConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchInferenceJobInput = {
    import BatchInferenceJobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchInferenceJobInput
      .builder()
      .s3DataSource(s3DataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly =
    zio.aws.personalize.model.BatchInferenceJobInput.wrap(buildAwsValue())
}
object BatchInferenceJobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchInferenceJobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchInferenceJobInput =
      zio.aws.personalize.model.BatchInferenceJobInput(s3DataSource.asEditable)
    def s3DataSource: zio.aws.personalize.model.S3DataConfig.ReadOnly
    def getS3DataSource
        : ZIO[Any, Nothing, zio.aws.personalize.model.S3DataConfig.ReadOnly] =
      ZIO.succeed(s3DataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchInferenceJobInput
  ) extends zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly {
    override val s3DataSource: zio.aws.personalize.model.S3DataConfig.ReadOnly =
      zio.aws.personalize.model.S3DataConfig.wrap(impl.s3DataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchInferenceJobInput
  ): zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly = new Wrapper(
    impl
  )
}
