package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchInferenceJobOutput(
    s3DataDestination: zio.aws.personalize.model.S3DataConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchInferenceJobOutput = {
    import BatchInferenceJobOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchInferenceJobOutput
      .builder()
      .s3DataDestination(s3DataDestination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly =
    zio.aws.personalize.model.BatchInferenceJobOutput.wrap(buildAwsValue())
}
object BatchInferenceJobOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchInferenceJobOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchInferenceJobOutput =
      zio.aws.personalize.model
        .BatchInferenceJobOutput(s3DataDestination.asEditable)
    def s3DataDestination: zio.aws.personalize.model.S3DataConfig.ReadOnly
    def getS3DataDestination
        : ZIO[Any, Nothing, zio.aws.personalize.model.S3DataConfig.ReadOnly] =
      ZIO.succeed(s3DataDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchInferenceJobOutput
  ) extends zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly {
    override val s3DataDestination
        : zio.aws.personalize.model.S3DataConfig.ReadOnly =
      zio.aws.personalize.model.S3DataConfig.wrap(impl.s3DataDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchInferenceJobOutput
  ): zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly = new Wrapper(
    impl
  )
}
