package zio.aws.personalize.model
import java.time.Instant
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  TransactionsPerSecond,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Campaign(
    name: Option[Name] = None,
    campaignArn: Option[Arn] = None,
    solutionVersionArn: Option[Arn] = None,
    minProvisionedTPS: Option[TransactionsPerSecond] = None,
    campaignConfig: Option[zio.aws.personalize.model.CampaignConfig] = None,
    status: Option[Status] = None,
    failureReason: Option[FailureReason] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    latestCampaignUpdate: Option[
      zio.aws.personalize.model.CampaignUpdateSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Campaign = {
    import Campaign.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Campaign
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        campaignArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.campaignArn)
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        minProvisionedTPS.map(value =>
          TransactionsPerSecond.unwrap(value): Integer
        )
      )(_.minProvisionedTPS)
      .optionallyWith(campaignConfig.map(value => value.buildAwsValue()))(
        _.campaignConfig
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(latestCampaignUpdate.map(value => value.buildAwsValue()))(
        _.latestCampaignUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Campaign.ReadOnly =
    zio.aws.personalize.model.Campaign.wrap(buildAwsValue())
}
object Campaign {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Campaign
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Campaign =
      zio.aws.personalize.model.Campaign(
        name.map(value => value),
        campaignArn.map(value => value),
        solutionVersionArn.map(value => value),
        minProvisionedTPS.map(value => value),
        campaignConfig.map(value => value.asEditable),
        status.map(value => value),
        failureReason.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        latestCampaignUpdate.map(value => value.asEditable)
      )
    def name: Option[Name]
    def campaignArn: Option[Arn]
    def solutionVersionArn: Option[Arn]
    def minProvisionedTPS: Option[TransactionsPerSecond]
    def campaignConfig
        : Option[zio.aws.personalize.model.CampaignConfig.ReadOnly]
    def status: Option[Status]
    def failureReason: Option[FailureReason]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def latestCampaignUpdate
        : Option[zio.aws.personalize.model.CampaignUpdateSummary.ReadOnly]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCampaignArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("campaignArn", campaignArn)
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getMinProvisionedTPS: ZIO[Any, AwsError, TransactionsPerSecond] =
      AwsError.unwrapOptionField("minProvisionedTPS", minProvisionedTPS)
    def getCampaignConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.CampaignConfig.ReadOnly
    ] = AwsError.unwrapOptionField("campaignConfig", campaignConfig)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getLatestCampaignUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.CampaignUpdateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("latestCampaignUpdate", latestCampaignUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Campaign
  ) extends zio.aws.personalize.model.Campaign.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val campaignArn: Option[Arn] = scala
      .Option(impl.campaignArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val solutionVersionArn: Option[Arn] = scala
      .Option(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val minProvisionedTPS: Option[TransactionsPerSecond] = scala
      .Option(impl.minProvisionedTPS())
      .map(value =>
        zio.aws.personalize.model.primitives.TransactionsPerSecond(value)
      )
    override val campaignConfig
        : Option[zio.aws.personalize.model.CampaignConfig.ReadOnly] = scala
      .Option(impl.campaignConfig())
      .map(value => zio.aws.personalize.model.CampaignConfig.wrap(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val latestCampaignUpdate
        : Option[zio.aws.personalize.model.CampaignUpdateSummary.ReadOnly] =
      scala
        .Option(impl.latestCampaignUpdate())
        .map(value =>
          zio.aws.personalize.model.CampaignUpdateSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Campaign
  ): zio.aws.personalize.model.Campaign.ReadOnly = new Wrapper(impl)
}
