package zio.aws.personalize.model
import java.time.Instant
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  TransactionsPerSecond
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CampaignUpdateSummary(
    solutionVersionArn: Option[Arn] = None,
    minProvisionedTPS: Option[TransactionsPerSecond] = None,
    campaignConfig: Option[zio.aws.personalize.model.CampaignConfig] = None,
    status: Option[Status] = None,
    failureReason: Option[FailureReason] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CampaignUpdateSummary = {
    import CampaignUpdateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CampaignUpdateSummary
      .builder()
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        minProvisionedTPS.map(value =>
          TransactionsPerSecond.unwrap(value): Integer
        )
      )(_.minProvisionedTPS)
      .optionallyWith(campaignConfig.map(value => value.buildAwsValue()))(
        _.campaignConfig
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CampaignUpdateSummary.ReadOnly =
    zio.aws.personalize.model.CampaignUpdateSummary.wrap(buildAwsValue())
}
object CampaignUpdateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CampaignUpdateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CampaignUpdateSummary =
      zio.aws.personalize.model.CampaignUpdateSummary(
        solutionVersionArn.map(value => value),
        minProvisionedTPS.map(value => value),
        campaignConfig.map(value => value.asEditable),
        status.map(value => value),
        failureReason.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def solutionVersionArn: Option[Arn]
    def minProvisionedTPS: Option[TransactionsPerSecond]
    def campaignConfig
        : Option[zio.aws.personalize.model.CampaignConfig.ReadOnly]
    def status: Option[Status]
    def failureReason: Option[FailureReason]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getMinProvisionedTPS: ZIO[Any, AwsError, TransactionsPerSecond] =
      AwsError.unwrapOptionField("minProvisionedTPS", minProvisionedTPS)
    def getCampaignConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.CampaignConfig.ReadOnly
    ] = AwsError.unwrapOptionField("campaignConfig", campaignConfig)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CampaignUpdateSummary
  ) extends zio.aws.personalize.model.CampaignUpdateSummary.ReadOnly {
    override val solutionVersionArn: Option[Arn] = scala
      .Option(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val minProvisionedTPS: Option[TransactionsPerSecond] = scala
      .Option(impl.minProvisionedTPS())
      .map(value =>
        zio.aws.personalize.model.primitives.TransactionsPerSecond(value)
      )
    override val campaignConfig
        : Option[zio.aws.personalize.model.CampaignConfig.ReadOnly] = scala
      .Option(impl.campaignConfig())
      .map(value => zio.aws.personalize.model.CampaignConfig.wrap(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CampaignUpdateSummary
  ): zio.aws.personalize.model.CampaignUpdateSummary.ReadOnly = new Wrapper(
    impl
  )
}
