package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  ContinuousMaxValue,
  ContinuousMinValue,
  ParameterName
}
import scala.jdk.CollectionConverters.*
final case class ContinuousHyperParameterRange(
    name: Option[ParameterName] = None,
    minValue: Option[ContinuousMinValue] = None,
    maxValue: Option[ContinuousMaxValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange = {
    import ContinuousHyperParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange
      .builder()
      .optionallyWith(
        name.map(value => ParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        minValue.map(value =>
          ContinuousMinValue.unwrap(value): java.lang.Double
        )
      )(_.minValue)
      .optionallyWith(
        maxValue.map(value =>
          ContinuousMaxValue.unwrap(value): java.lang.Double
        )
      )(_.maxValue)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly =
    zio.aws.personalize.model.ContinuousHyperParameterRange
      .wrap(buildAwsValue())
}
object ContinuousHyperParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ContinuousHyperParameterRange =
      zio.aws.personalize.model.ContinuousHyperParameterRange(
        name.map(value => value),
        minValue.map(value => value),
        maxValue.map(value => value)
      )
    def name: Option[ParameterName]
    def minValue: Option[ContinuousMinValue]
    def maxValue: Option[ContinuousMaxValue]
    def getName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getMinValue: ZIO[Any, AwsError, ContinuousMinValue] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, ContinuousMaxValue] =
      AwsError.unwrapOptionField("maxValue", maxValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange
  ) extends zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly {
    override val name: Option[ParameterName] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.ParameterName(value))
    override val minValue: Option[ContinuousMinValue] = scala
      .Option(impl.minValue())
      .map(value =>
        zio.aws.personalize.model.primitives.ContinuousMinValue(value)
      )
    override val maxValue: Option[ContinuousMaxValue] = scala
      .Option(impl.maxValue())
      .map(value =>
        zio.aws.personalize.model.primitives.ContinuousMaxValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange
  ): zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly =
    new Wrapper(impl)
}
