package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  RoleArn,
  NumBatchResults,
  Arn,
  Name
}
import scala.jdk.CollectionConverters.*
final case class CreateBatchInferenceJobRequest(
    jobName: Name,
    solutionVersionArn: Arn,
    filterArn: Option[Arn] = None,
    numResults: Option[NumBatchResults] = None,
    jobInput: zio.aws.personalize.model.BatchInferenceJobInput,
    jobOutput: zio.aws.personalize.model.BatchInferenceJobOutput,
    roleArn: RoleArn,
    batchInferenceJobConfig: Option[
      zio.aws.personalize.model.BatchInferenceJobConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest = {
    import CreateBatchInferenceJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest
      .builder()
      .jobName(Name.unwrap(jobName): java.lang.String)
      .solutionVersionArn(Arn.unwrap(solutionVersionArn): java.lang.String)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        numResults.map(value => NumBatchResults.unwrap(value): Integer)
      )(_.numResults)
      .jobInput(jobInput.buildAwsValue())
      .jobOutput(jobOutput.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        batchInferenceJobConfig.map(value => value.buildAwsValue())
      )(_.batchInferenceJobConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateBatchInferenceJobRequest.ReadOnly =
    zio.aws.personalize.model.CreateBatchInferenceJobRequest
      .wrap(buildAwsValue())
}
object CreateBatchInferenceJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateBatchInferenceJobRequest =
      zio.aws.personalize.model.CreateBatchInferenceJobRequest(
        jobName,
        solutionVersionArn,
        filterArn.map(value => value),
        numResults.map(value => value),
        jobInput.asEditable,
        jobOutput.asEditable,
        roleArn,
        batchInferenceJobConfig.map(value => value.asEditable)
      )
    def jobName: Name
    def solutionVersionArn: Arn
    def filterArn: Option[Arn]
    def numResults: Option[NumBatchResults]
    def jobInput: zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly
    def jobOutput: zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly
    def roleArn: RoleArn
    def batchInferenceJobConfig
        : Option[zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly]
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getSolutionVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(solutionVersionArn)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getNumResults: ZIO[Any, AwsError, NumBatchResults] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly
    ] = ZIO.succeed(jobInput)
    def getJobOutput: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly
    ] = ZIO.succeed(jobOutput)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getBatchInferenceJobConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "batchInferenceJobConfig",
      batchInferenceJobConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest
  ) extends zio.aws.personalize.model.CreateBatchInferenceJobRequest.ReadOnly {
    override val jobName: Name =
      zio.aws.personalize.model.primitives.Name(impl.jobName())
    override val solutionVersionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionVersionArn())
    override val filterArn: Option[Arn] = scala
      .Option(impl.filterArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val numResults: Option[NumBatchResults] = scala
      .Option(impl.numResults())
      .map(value => zio.aws.personalize.model.primitives.NumBatchResults(value))
    override val jobInput
        : zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly =
      zio.aws.personalize.model.BatchInferenceJobInput.wrap(impl.jobInput())
    override val jobOutput
        : zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly =
      zio.aws.personalize.model.BatchInferenceJobOutput.wrap(impl.jobOutput())
    override val roleArn: RoleArn =
      zio.aws.personalize.model.primitives.RoleArn(impl.roleArn())
    override val batchInferenceJobConfig
        : Option[zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly] =
      scala
        .Option(impl.batchInferenceJobConfig())
        .map(value =>
          zio.aws.personalize.model.BatchInferenceJobConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest
  ): zio.aws.personalize.model.CreateBatchInferenceJobRequest.ReadOnly =
    new Wrapper(impl)
}
