package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateBatchInferenceJobResponse(
    batchInferenceJobArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse = {
    import CreateBatchInferenceJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse
      .builder()
      .optionallyWith(
        batchInferenceJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.batchInferenceJobArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateBatchInferenceJobResponse.ReadOnly =
    zio.aws.personalize.model.CreateBatchInferenceJobResponse
      .wrap(buildAwsValue())
}
object CreateBatchInferenceJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateBatchInferenceJobResponse =
      zio.aws.personalize.model.CreateBatchInferenceJobResponse(
        batchInferenceJobArn.map(value => value)
      )
    def batchInferenceJobArn: Option[Arn]
    def getBatchInferenceJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("batchInferenceJobArn", batchInferenceJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse
  ) extends zio.aws.personalize.model.CreateBatchInferenceJobResponse.ReadOnly {
    override val batchInferenceJobArn: Option[Arn] = scala
      .Option(impl.batchInferenceJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse
  ): zio.aws.personalize.model.CreateBatchInferenceJobResponse.ReadOnly =
    new Wrapper(impl)
}
