package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateBatchSegmentJobResponse(
    batchSegmentJobArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobResponse = {
    import CreateBatchSegmentJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobResponse
      .builder()
      .optionallyWith(
        batchSegmentJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.batchSegmentJobArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateBatchSegmentJobResponse.ReadOnly =
    zio.aws.personalize.model.CreateBatchSegmentJobResponse
      .wrap(buildAwsValue())
}
object CreateBatchSegmentJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateBatchSegmentJobResponse =
      zio.aws.personalize.model
        .CreateBatchSegmentJobResponse(batchSegmentJobArn.map(value => value))
    def batchSegmentJobArn: Option[Arn]
    def getBatchSegmentJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("batchSegmentJobArn", batchSegmentJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobResponse
  ) extends zio.aws.personalize.model.CreateBatchSegmentJobResponse.ReadOnly {
    override val batchSegmentJobArn: Option[Arn] = scala
      .Option(impl.batchSegmentJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobResponse
  ): zio.aws.personalize.model.CreateBatchSegmentJobResponse.ReadOnly =
    new Wrapper(impl)
}
