package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.{DatasetType, Arn, Name}
import scala.jdk.CollectionConverters.*
final case class CreateDatasetRequest(
    name: Name,
    schemaArn: Arn,
    datasetGroupArn: Arn,
    datasetType: DatasetType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .datasetType(DatasetType.unwrap(datasetType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateDatasetRequest.ReadOnly =
    zio.aws.personalize.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetRequest =
      zio.aws.personalize.model.CreateDatasetRequest(
        name,
        schemaArn,
        datasetGroupArn,
        datasetType
      )
    def name: Name
    def schemaArn: Arn
    def datasetGroupArn: Arn
    def datasetType: DatasetType
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getDatasetType: ZIO[Any, Nothing, DatasetType] =
      ZIO.succeed(datasetType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetRequest
  ) extends zio.aws.personalize.model.CreateDatasetRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val schemaArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.schemaArn())
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
    override val datasetType: DatasetType =
      zio.aws.personalize.model.primitives.DatasetType(impl.datasetType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetRequest
  ): zio.aws.personalize.model.CreateDatasetRequest.ReadOnly = new Wrapper(impl)
}
