package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateDatasetResponse(datasetArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetResponse
      .builder()
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateDatasetResponse.ReadOnly =
    zio.aws.personalize.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetResponse =
      zio.aws.personalize.model
        .CreateDatasetResponse(datasetArn.map(value => value))
    def datasetArn: Option[Arn]
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetResponse
  ) extends zio.aws.personalize.model.CreateDatasetResponse.ReadOnly {
    override val datasetArn: Option[Arn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetResponse
  ): zio.aws.personalize.model.CreateDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
