package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{TrackingId, Arn}
import scala.jdk.CollectionConverters.*
final case class CreateEventTrackerResponse(
    eventTrackerArn: Option[Arn] = None,
    trackingId: Option[TrackingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse = {
    import CreateEventTrackerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse
      .builder()
      .optionallyWith(
        eventTrackerArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventTrackerArn)
      .optionallyWith(
        trackingId.map(value => TrackingId.unwrap(value): java.lang.String)
      )(_.trackingId)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly =
    zio.aws.personalize.model.CreateEventTrackerResponse.wrap(buildAwsValue())
}
object CreateEventTrackerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateEventTrackerResponse =
      zio.aws.personalize.model.CreateEventTrackerResponse(
        eventTrackerArn.map(value => value),
        trackingId.map(value => value)
      )
    def eventTrackerArn: Option[Arn]
    def trackingId: Option[TrackingId]
    def getEventTrackerArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventTrackerArn", eventTrackerArn)
    def getTrackingId: ZIO[Any, AwsError, TrackingId] =
      AwsError.unwrapOptionField("trackingId", trackingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse
  ) extends zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly {
    override val eventTrackerArn: Option[Arn] = scala
      .Option(impl.eventTrackerArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val trackingId: Option[TrackingId] = scala
      .Option(impl.trackingId())
      .map(value => zio.aws.personalize.model.primitives.TrackingId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse
  ): zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly =
    new Wrapper(impl)
}
