package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateSchemaResponse(schemaArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateSchemaResponse = {
    import CreateSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateSchemaResponse
      .builder()
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateSchemaResponse.ReadOnly =
    zio.aws.personalize.model.CreateSchemaResponse.wrap(buildAwsValue())
}
object CreateSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateSchemaResponse =
      zio.aws.personalize.model
        .CreateSchemaResponse(schemaArn.map(value => value))
    def schemaArn: Option[Arn]
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateSchemaResponse
  ) extends zio.aws.personalize.model.CreateSchemaResponse.ReadOnly {
    override val schemaArn: Option[Arn] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateSchemaResponse
  ): zio.aws.personalize.model.CreateSchemaResponse.ReadOnly = new Wrapper(impl)
}
