package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  Arn,
  DatasetType,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Dataset(
    name: Option[Name] = None,
    datasetArn: Option[Arn] = None,
    datasetGroupArn: Option[Arn] = None,
    datasetType: Option[DatasetType] = None,
    schemaArn: Option[Arn] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Dataset = {
    import Dataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Dataset
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        datasetType.map(value => DatasetType.unwrap(value): java.lang.String)
      )(_.datasetType)
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Dataset.ReadOnly =
    zio.aws.personalize.model.Dataset.wrap(buildAwsValue())
}
object Dataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Dataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Dataset =
      zio.aws.personalize.model.Dataset(
        name.map(value => value),
        datasetArn.map(value => value),
        datasetGroupArn.map(value => value),
        datasetType.map(value => value),
        schemaArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Option[Name]
    def datasetArn: Option[Arn]
    def datasetGroupArn: Option[Arn]
    def datasetType: Option[DatasetType]
    def schemaArn: Option[Arn]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getDatasetType: ZIO[Any, AwsError, DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Dataset
  ) extends zio.aws.personalize.model.Dataset.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val datasetArn: Option[Arn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetType: Option[DatasetType] = scala
      .Option(impl.datasetType())
      .map(value => zio.aws.personalize.model.primitives.DatasetType(value))
    override val schemaArn: Option[Arn] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Dataset
  ): zio.aws.personalize.model.Dataset.ReadOnly = new Wrapper(impl)
}
