package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DatasetImportJob(
    jobName: Option[Name] = None,
    datasetImportJobArn: Option[Arn] = None,
    datasetArn: Option[Arn] = None,
    dataSource: Option[zio.aws.personalize.model.DataSource] = None,
    roleArn: Option[Arn] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    failureReason: Option[FailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetImportJob = {
    import DatasetImportJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetImportJob
      .builder()
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        datasetImportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetImportJobArn)
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetImportJob.ReadOnly =
    zio.aws.personalize.model.DatasetImportJob.wrap(buildAwsValue())
}
object DatasetImportJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetImportJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetImportJob =
      zio.aws.personalize.model.DatasetImportJob(
        jobName.map(value => value),
        datasetImportJobArn.map(value => value),
        datasetArn.map(value => value),
        dataSource.map(value => value.asEditable),
        roleArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value)
      )
    def jobName: Option[Name]
    def datasetImportJobArn: Option[Arn]
    def datasetArn: Option[Arn]
    def dataSource: Option[zio.aws.personalize.model.DataSource.ReadOnly]
    def roleArn: Option[Arn]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def failureReason: Option[FailureReason]
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getDatasetImportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetImportJobArn", datasetImportJobArn)
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.personalize.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetImportJob
  ) extends zio.aws.personalize.model.DatasetImportJob.ReadOnly {
    override val jobName: Option[Name] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val datasetImportJobArn: Option[Arn] = scala
      .Option(impl.datasetImportJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetArn: Option[Arn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val dataSource
        : Option[zio.aws.personalize.model.DataSource.ReadOnly] = scala
      .Option(impl.dataSource())
      .map(value => zio.aws.personalize.model.DataSource.wrap(value))
    override val roleArn: Option[Arn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetImportJob
  ): zio.aws.personalize.model.DatasetImportJob.ReadOnly = new Wrapper(impl)
}
