package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Date, Arn, Name}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DatasetSchemaSummary(
    name: Option[Name] = None,
    schemaArn: Option[Arn] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    domain: Option[zio.aws.personalize.model.Domain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary = {
    import DatasetSchemaSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly =
    zio.aws.personalize.model.DatasetSchemaSummary.wrap(buildAwsValue())
}
object DatasetSchemaSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetSchemaSummary =
      zio.aws.personalize.model.DatasetSchemaSummary(
        name.map(value => value),
        schemaArn.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        domain.map(value => value)
      )
    def name: Option[Name]
    def schemaArn: Option[Arn]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def domain: Option[zio.aws.personalize.model.Domain]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary
  ) extends zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val schemaArn: Option[Arn] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val domain: Option[zio.aws.personalize.model.Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary
  ): zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly = new Wrapper(impl)
}
