package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Tunable,
  IntegerMaxValue,
  IntegerMinValue,
  ParameterName
}
import scala.jdk.CollectionConverters.*
final case class DefaultIntegerHyperParameterRange(
    name: Option[ParameterName] = None,
    minValue: Option[IntegerMinValue] = None,
    maxValue: Option[IntegerMaxValue] = None,
    isTunable: Option[Tunable] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange = {
    import DefaultIntegerHyperParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange
      .builder()
      .optionallyWith(
        name.map(value => ParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        minValue.map(value => IntegerMinValue.unwrap(value): Integer)
      )(_.minValue)
      .optionallyWith(
        maxValue.map(value => IntegerMaxValue.unwrap(value): Integer)
      )(_.maxValue)
      .optionallyWith(
        isTunable.map(value => Tunable.unwrap(value): java.lang.Boolean)
      )(_.isTunable)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly =
    zio.aws.personalize.model.DefaultIntegerHyperParameterRange
      .wrap(buildAwsValue())
}
object DefaultIntegerHyperParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.DefaultIntegerHyperParameterRange =
      zio.aws.personalize.model.DefaultIntegerHyperParameterRange(
        name.map(value => value),
        minValue.map(value => value),
        maxValue.map(value => value),
        isTunable.map(value => value)
      )
    def name: Option[ParameterName]
    def minValue: Option[IntegerMinValue]
    def maxValue: Option[IntegerMaxValue]
    def isTunable: Option[Tunable]
    def getName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getMinValue: ZIO[Any, AwsError, IntegerMinValue] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, IntegerMaxValue] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getIsTunable: ZIO[Any, AwsError, Tunable] =
      AwsError.unwrapOptionField("isTunable", isTunable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange
  ) extends zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly {
    override val name: Option[ParameterName] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.ParameterName(value))
    override val minValue: Option[IntegerMinValue] = scala
      .Option(impl.minValue())
      .map(value => zio.aws.personalize.model.primitives.IntegerMinValue(value))
    override val maxValue: Option[IntegerMaxValue] = scala
      .Option(impl.maxValue())
      .map(value => zio.aws.personalize.model.primitives.IntegerMaxValue(value))
    override val isTunable: Option[Tunable] = scala
      .Option(impl.isTunable())
      .map(value => zio.aws.personalize.model.primitives.Tunable(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange
  ): zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly =
    new Wrapper(impl)
}
