package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteDatasetGroupRequest(datasetGroupArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest = {
    import DeleteDatasetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest
      .builder()
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DeleteDatasetGroupRequest.ReadOnly =
    zio.aws.personalize.model.DeleteDatasetGroupRequest.wrap(buildAwsValue())
}
object DeleteDatasetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteDatasetGroupRequest =
      zio.aws.personalize.model.DeleteDatasetGroupRequest(datasetGroupArn)
    def datasetGroupArn: Arn
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest
  ) extends zio.aws.personalize.model.DeleteDatasetGroupRequest.ReadOnly {
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest
  ): zio.aws.personalize.model.DeleteDatasetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
