package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteFilterRequest(filterArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteFilterRequest = {
    import DeleteFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteFilterRequest
      .builder()
      .filterArn(Arn.unwrap(filterArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DeleteFilterRequest.ReadOnly =
    zio.aws.personalize.model.DeleteFilterRequest.wrap(buildAwsValue())
}
object DeleteFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteFilterRequest =
      zio.aws.personalize.model.DeleteFilterRequest(filterArn)
    def filterArn: Arn
    def getFilterArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(filterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteFilterRequest
  ) extends zio.aws.personalize.model.DeleteFilterRequest.ReadOnly {
    override val filterArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.filterArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteFilterRequest
  ): zio.aws.personalize.model.DeleteFilterRequest.ReadOnly = new Wrapper(impl)
}
