package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetGroupRequest(datasetGroupArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest = {
    import DescribeDatasetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest
      .builder()
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeDatasetGroupRequest.ReadOnly =
    zio.aws.personalize.model.DescribeDatasetGroupRequest.wrap(buildAwsValue())
}
object DescribeDatasetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeDatasetGroupRequest =
      zio.aws.personalize.model.DescribeDatasetGroupRequest(datasetGroupArn)
    def datasetGroupArn: Arn
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest
  ) extends zio.aws.personalize.model.DescribeDatasetGroupRequest.ReadOnly {
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest
  ): zio.aws.personalize.model.DescribeDatasetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
