package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeFilterResponse(
    filter: Option[zio.aws.personalize.model.Filter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeFilterResponse = {
    import DescribeFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeFilterResponse
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeFilterResponse.ReadOnly =
    zio.aws.personalize.model.DescribeFilterResponse.wrap(buildAwsValue())
}
object DescribeFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeFilterResponse =
      zio.aws.personalize.model
        .DescribeFilterResponse(filter.map(value => value.asEditable))
    def filter: Option[zio.aws.personalize.model.Filter.ReadOnly]
    def getFilter
        : ZIO[Any, AwsError, zio.aws.personalize.model.Filter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeFilterResponse
  ) extends zio.aws.personalize.model.DescribeFilterResponse.ReadOnly {
    override val filter: Option[zio.aws.personalize.model.Filter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value => zio.aws.personalize.model.Filter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeFilterResponse
  ): zio.aws.personalize.model.DescribeFilterResponse.ReadOnly = new Wrapper(
    impl
  )
}
