package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeRecipeResponse(
    recipe: Option[zio.aws.personalize.model.Recipe] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse = {
    import DescribeRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse
      .builder()
      .optionallyWith(recipe.map(value => value.buildAwsValue()))(_.recipe)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeRecipeResponse.ReadOnly =
    zio.aws.personalize.model.DescribeRecipeResponse.wrap(buildAwsValue())
}
object DescribeRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeRecipeResponse =
      zio.aws.personalize.model
        .DescribeRecipeResponse(recipe.map(value => value.asEditable))
    def recipe: Option[zio.aws.personalize.model.Recipe.ReadOnly]
    def getRecipe
        : ZIO[Any, AwsError, zio.aws.personalize.model.Recipe.ReadOnly] =
      AwsError.unwrapOptionField("recipe", recipe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse
  ) extends zio.aws.personalize.model.DescribeRecipeResponse.ReadOnly {
    override val recipe: Option[zio.aws.personalize.model.Recipe.ReadOnly] =
      scala
        .Option(impl.recipe())
        .map(value => zio.aws.personalize.model.Recipe.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse
  ): zio.aws.personalize.model.DescribeRecipeResponse.ReadOnly = new Wrapper(
    impl
  )
}
