package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeSchemaRequest(schemaArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest = {
    import DescribeSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeSchemaRequest.ReadOnly =
    zio.aws.personalize.model.DescribeSchemaRequest.wrap(buildAwsValue())
}
object DescribeSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeSchemaRequest =
      zio.aws.personalize.model.DescribeSchemaRequest(schemaArn)
    def schemaArn: Arn
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest
  ) extends zio.aws.personalize.model.DescribeSchemaRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.schemaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest
  ): zio.aws.personalize.model.DescribeSchemaRequest.ReadOnly = new Wrapper(
    impl
  )
}
