package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSolutionResponse(
    solution: Option[zio.aws.personalize.model.Solution] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse = {
    import DescribeSolutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse
      .builder()
      .optionallyWith(solution.map(value => value.buildAwsValue()))(_.solution)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly =
    zio.aws.personalize.model.DescribeSolutionResponse.wrap(buildAwsValue())
}
object DescribeSolutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeSolutionResponse =
      zio.aws.personalize.model
        .DescribeSolutionResponse(solution.map(value => value.asEditable))
    def solution: Option[zio.aws.personalize.model.Solution.ReadOnly]
    def getSolution
        : ZIO[Any, AwsError, zio.aws.personalize.model.Solution.ReadOnly] =
      AwsError.unwrapOptionField("solution", solution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse
  ) extends zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly {
    override val solution: Option[zio.aws.personalize.model.Solution.ReadOnly] =
      scala
        .Option(impl.solution())
        .map(value => zio.aws.personalize.model.Solution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse
  ): zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
