package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  TrackingId,
  Date,
  AccountId,
  Arn,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EventTracker(
    name: Option[Name] = None,
    eventTrackerArn: Option[Arn] = None,
    accountId: Option[AccountId] = None,
    trackingId: Option[TrackingId] = None,
    datasetGroupArn: Option[Arn] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.EventTracker = {
    import EventTracker.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.EventTracker
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        eventTrackerArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventTrackerArn)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        trackingId.map(value => TrackingId.unwrap(value): java.lang.String)
      )(_.trackingId)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.EventTracker.ReadOnly =
    zio.aws.personalize.model.EventTracker.wrap(buildAwsValue())
}
object EventTracker {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.EventTracker
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.EventTracker =
      zio.aws.personalize.model.EventTracker(
        name.map(value => value),
        eventTrackerArn.map(value => value),
        accountId.map(value => value),
        trackingId.map(value => value),
        datasetGroupArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Option[Name]
    def eventTrackerArn: Option[Arn]
    def accountId: Option[AccountId]
    def trackingId: Option[TrackingId]
    def datasetGroupArn: Option[Arn]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getEventTrackerArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventTrackerArn", eventTrackerArn)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getTrackingId: ZIO[Any, AwsError, TrackingId] =
      AwsError.unwrapOptionField("trackingId", trackingId)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.EventTracker
  ) extends zio.aws.personalize.model.EventTracker.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val eventTrackerArn: Option[Arn] = scala
      .Option(impl.eventTrackerArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.personalize.model.primitives.AccountId(value))
    override val trackingId: Option[TrackingId] = scala
      .Option(impl.trackingId())
      .map(value => zio.aws.personalize.model.primitives.TrackingId(value))
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.EventTracker
  ): zio.aws.personalize.model.EventTracker.ReadOnly = new Wrapper(impl)
}
