package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Date, Status, Arn, Name}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EventTrackerSummary(
    name: Option[Name] = None,
    eventTrackerArn: Option[Arn] = None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.EventTrackerSummary = {
    import EventTrackerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.EventTrackerSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        eventTrackerArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventTrackerArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.EventTrackerSummary.ReadOnly =
    zio.aws.personalize.model.EventTrackerSummary.wrap(buildAwsValue())
}
object EventTrackerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.EventTrackerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.EventTrackerSummary =
      zio.aws.personalize.model.EventTrackerSummary(
        name.map(value => value),
        eventTrackerArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Option[Name]
    def eventTrackerArn: Option[Arn]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getEventTrackerArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventTrackerArn", eventTrackerArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.EventTrackerSummary
  ) extends zio.aws.personalize.model.EventTrackerSummary.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val eventTrackerArn: Option[Arn] = scala
      .Option(impl.eventTrackerArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.EventTrackerSummary
  ): zio.aws.personalize.model.EventTrackerSummary.ReadOnly = new Wrapper(impl)
}
