package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  ParameterName,
  ParameterValue,
  Date,
  Arn,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class FeatureTransformation(
    name: Option[Name] = None,
    featureTransformationArn: Option[Arn] = None,
    defaultParameters: Option[Map[ParameterName, ParameterValue]] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    status: Option[Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.FeatureTransformation = {
    import FeatureTransformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.FeatureTransformation
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        featureTransformationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.featureTransformationArn)
      .optionallyWith(
        defaultParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.defaultParameters)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.FeatureTransformation.ReadOnly =
    zio.aws.personalize.model.FeatureTransformation.wrap(buildAwsValue())
}
object FeatureTransformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.FeatureTransformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.FeatureTransformation =
      zio.aws.personalize.model.FeatureTransformation(
        name.map(value => value),
        featureTransformationArn.map(value => value),
        defaultParameters.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        status.map(value => value)
      )
    def name: Option[Name]
    def featureTransformationArn: Option[Arn]
    def defaultParameters: Option[Map[ParameterName, ParameterValue]]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def status: Option[Status]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getFeatureTransformationArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("featureTransformationArn", featureTransformationArn)
    def getDefaultParameters
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField("defaultParameters", defaultParameters)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.FeatureTransformation
  ) extends zio.aws.personalize.model.FeatureTransformation.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val featureTransformationArn: Option[Arn] = scala
      .Option(impl.featureTransformationArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val defaultParameters: Option[Map[ParameterName, ParameterValue]] =
      scala
        .Option(impl.defaultParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.personalize.model.primitives.ParameterName(
                key
              ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
            })
            .toMap
        )
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.FeatureTransformation
  ): zio.aws.personalize.model.FeatureTransformation.ReadOnly = new Wrapper(
    impl
  )
}
