package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class GetSolutionMetricsRequest(solutionVersionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest = {
    import GetSolutionMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest
      .builder()
      .solutionVersionArn(Arn.unwrap(solutionVersionArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.GetSolutionMetricsRequest.ReadOnly =
    zio.aws.personalize.model.GetSolutionMetricsRequest.wrap(buildAwsValue())
}
object GetSolutionMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.GetSolutionMetricsRequest =
      zio.aws.personalize.model.GetSolutionMetricsRequest(solutionVersionArn)
    def solutionVersionArn: Arn
    def getSolutionVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(solutionVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest
  ) extends zio.aws.personalize.model.GetSolutionMetricsRequest.ReadOnly {
    override val solutionVersionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest
  ): zio.aws.personalize.model.GetSolutionMetricsRequest.ReadOnly = new Wrapper(
    impl
  )
}
