package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HyperParameterRanges(
    integerHyperParameterRanges: Option[
      Iterable[zio.aws.personalize.model.IntegerHyperParameterRange]
    ] = None,
    continuousHyperParameterRanges: Option[
      Iterable[zio.aws.personalize.model.ContinuousHyperParameterRange]
    ] = None,
    categoricalHyperParameterRanges: Option[
      Iterable[zio.aws.personalize.model.CategoricalHyperParameterRange]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.HyperParameterRanges = {
    import HyperParameterRanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.HyperParameterRanges
      .builder()
      .optionallyWith(
        integerHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integerHyperParameterRanges)
      .optionallyWith(
        continuousHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.continuousHyperParameterRanges)
      .optionallyWith(
        categoricalHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoricalHyperParameterRanges)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.HyperParameterRanges.ReadOnly =
    zio.aws.personalize.model.HyperParameterRanges.wrap(buildAwsValue())
}
object HyperParameterRanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.HyperParameterRanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.HyperParameterRanges =
      zio.aws.personalize.model.HyperParameterRanges(
        integerHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        continuousHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        categoricalHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def integerHyperParameterRanges: Option[
      List[zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly]
    ]
    def continuousHyperParameterRanges: Option[
      List[zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly]
    ]
    def categoricalHyperParameterRanges: Option[
      List[zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly]
    ]
    def getIntegerHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "integerHyperParameterRanges",
      integerHyperParameterRanges
    )
    def getContinuousHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "continuousHyperParameterRanges",
      continuousHyperParameterRanges
    )
    def getCategoricalHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoricalHyperParameterRanges",
      categoricalHyperParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.HyperParameterRanges
  ) extends zio.aws.personalize.model.HyperParameterRanges.ReadOnly {
    override val integerHyperParameterRanges: Option[
      List[zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly]
    ] = scala
      .Option(impl.integerHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.IntegerHyperParameterRange.wrap(item)
        }.toList
      )
    override val continuousHyperParameterRanges: Option[
      List[zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly]
    ] = scala
      .Option(impl.continuousHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.ContinuousHyperParameterRange.wrap(item)
        }.toList
      )
    override val categoricalHyperParameterRanges: Option[
      List[zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly]
    ] = scala
      .Option(impl.categoricalHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.CategoricalHyperParameterRange.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.HyperParameterRanges
  ): zio.aws.personalize.model.HyperParameterRanges.ReadOnly = new Wrapper(impl)
}
