package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListBatchSegmentJobsResponse(
    batchSegmentJobs: Option[
      Iterable[zio.aws.personalize.model.BatchSegmentJobSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse = {
    import ListBatchSegmentJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse
      .builder()
      .optionallyWith(
        batchSegmentJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.batchSegmentJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListBatchSegmentJobsResponse.ReadOnly =
    zio.aws.personalize.model.ListBatchSegmentJobsResponse.wrap(buildAwsValue())
}
object ListBatchSegmentJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListBatchSegmentJobsResponse =
      zio.aws.personalize.model.ListBatchSegmentJobsResponse(
        batchSegmentJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def batchSegmentJobs: Option[
      List[zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getBatchSegmentJobs: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("batchSegmentJobs", batchSegmentJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse
  ) extends zio.aws.personalize.model.ListBatchSegmentJobsResponse.ReadOnly {
    override val batchSegmentJobs: Option[
      List[zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly]
    ] = scala
      .Option(impl.batchSegmentJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.BatchSegmentJobSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse
  ): zio.aws.personalize.model.ListBatchSegmentJobsResponse.ReadOnly =
    new Wrapper(impl)
}
