package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListDatasetGroupsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest = {
    import ListDatasetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListDatasetGroupsRequest.ReadOnly =
    zio.aws.personalize.model.ListDatasetGroupsRequest.wrap(buildAwsValue())
}
object ListDatasetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListDatasetGroupsRequest =
      zio.aws.personalize.model.ListDatasetGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest
  ) extends zio.aws.personalize.model.ListDatasetGroupsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest
  ): zio.aws.personalize.model.ListDatasetGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
