package zio.aws.personalize.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{MaxResults, NextToken, Arn}
import scala.jdk.CollectionConverters.*
final case class ListDatasetImportJobsRequest(
    datasetArn: Option[Arn] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest = {
    import ListDatasetImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest
      .builder()
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListDatasetImportJobsRequest.ReadOnly =
    zio.aws.personalize.model.ListDatasetImportJobsRequest.wrap(buildAwsValue())
}
object ListDatasetImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListDatasetImportJobsRequest =
      zio.aws.personalize.model.ListDatasetImportJobsRequest(
        datasetArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def datasetArn: Option[Arn]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest
  ) extends zio.aws.personalize.model.ListDatasetImportJobsRequest.ReadOnly {
    override val datasetArn: Option[Arn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest
  ): zio.aws.personalize.model.ListDatasetImportJobsRequest.ReadOnly =
    new Wrapper(impl)
}
