package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListEventTrackersResponse(
    eventTrackers: Option[
      Iterable[zio.aws.personalize.model.EventTrackerSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse = {
    import ListEventTrackersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse
      .builder()
      .optionallyWith(
        eventTrackers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventTrackers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly =
    zio.aws.personalize.model.ListEventTrackersResponse.wrap(buildAwsValue())
}
object ListEventTrackersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListEventTrackersResponse =
      zio.aws.personalize.model.ListEventTrackersResponse(
        eventTrackers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventTrackers
        : Option[List[zio.aws.personalize.model.EventTrackerSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getEventTrackers: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.EventTrackerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("eventTrackers", eventTrackers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse
  ) extends zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly {
    override val eventTrackers
        : Option[List[zio.aws.personalize.model.EventTrackerSummary.ReadOnly]] =
      scala
        .Option(impl.eventTrackers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.EventTrackerSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse
  ): zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly = new Wrapper(
    impl
  )
}
