package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.ItemAttribute
import scala.jdk.CollectionConverters.*
final case class OptimizationObjective(
    itemAttribute: Option[ItemAttribute] = None,
    objectiveSensitivity: Option[
      zio.aws.personalize.model.ObjectiveSensitivity
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.OptimizationObjective = {
    import OptimizationObjective.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.OptimizationObjective
      .builder()
      .optionallyWith(
        itemAttribute.map(value =>
          ItemAttribute.unwrap(value): java.lang.String
        )
      )(_.itemAttribute)
      .optionallyWith(objectiveSensitivity.map(value => value.unwrap))(
        _.objectiveSensitivity
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.OptimizationObjective.ReadOnly =
    zio.aws.personalize.model.OptimizationObjective.wrap(buildAwsValue())
}
object OptimizationObjective {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.OptimizationObjective
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.OptimizationObjective =
      zio.aws.personalize.model.OptimizationObjective(
        itemAttribute.map(value => value),
        objectiveSensitivity.map(value => value)
      )
    def itemAttribute: Option[ItemAttribute]
    def objectiveSensitivity
        : Option[zio.aws.personalize.model.ObjectiveSensitivity]
    def getItemAttribute: ZIO[Any, AwsError, ItemAttribute] =
      AwsError.unwrapOptionField("itemAttribute", itemAttribute)
    def getObjectiveSensitivity
        : ZIO[Any, AwsError, zio.aws.personalize.model.ObjectiveSensitivity] =
      AwsError.unwrapOptionField("objectiveSensitivity", objectiveSensitivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.OptimizationObjective
  ) extends zio.aws.personalize.model.OptimizationObjective.ReadOnly {
    override val itemAttribute: Option[ItemAttribute] = scala
      .Option(impl.itemAttribute())
      .map(value => zio.aws.personalize.model.primitives.ItemAttribute(value))
    override val objectiveSensitivity
        : Option[zio.aws.personalize.model.ObjectiveSensitivity] = scala
      .Option(impl.objectiveSensitivity())
      .map(value => zio.aws.personalize.model.ObjectiveSensitivity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.OptimizationObjective
  ): zio.aws.personalize.model.OptimizationObjective.ReadOnly = new Wrapper(
    impl
  )
}
