package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  RecipeType,
  Arn,
  Description,
  Name
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Recipe(
    name: Option[Name] = None,
    recipeArn: Option[Arn] = None,
    algorithmArn: Option[Arn] = None,
    featureTransformationArn: Option[Arn] = None,
    status: Option[Status] = None,
    description: Option[Description] = None,
    creationDateTime: Option[Date] = None,
    recipeType: Option[RecipeType] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Recipe = {
    import Recipe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Recipe
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(
        algorithmArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.algorithmArn)
      .optionallyWith(
        featureTransformationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.featureTransformationArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        recipeType.map(value => RecipeType.unwrap(value): java.lang.String)
      )(_.recipeType)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Recipe.ReadOnly =
    zio.aws.personalize.model.Recipe.wrap(buildAwsValue())
}
object Recipe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Recipe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Recipe =
      zio.aws.personalize.model.Recipe(
        name.map(value => value),
        recipeArn.map(value => value),
        algorithmArn.map(value => value),
        featureTransformationArn.map(value => value),
        status.map(value => value),
        description.map(value => value),
        creationDateTime.map(value => value),
        recipeType.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Option[Name]
    def recipeArn: Option[Arn]
    def algorithmArn: Option[Arn]
    def featureTransformationArn: Option[Arn]
    def status: Option[Status]
    def description: Option[Description]
    def creationDateTime: Option[Date]
    def recipeType: Option[RecipeType]
    def lastUpdatedDateTime: Option[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getAlgorithmArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("algorithmArn", algorithmArn)
    def getFeatureTransformationArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("featureTransformationArn", featureTransformationArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getRecipeType: ZIO[Any, AwsError, RecipeType] =
      AwsError.unwrapOptionField("recipeType", recipeType)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Recipe
  ) extends zio.aws.personalize.model.Recipe.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val recipeArn: Option[Arn] = scala
      .Option(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val algorithmArn: Option[Arn] = scala
      .Option(impl.algorithmArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val featureTransformationArn: Option[Arn] = scala
      .Option(impl.featureTransformationArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.personalize.model.primitives.Description(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val recipeType: Option[RecipeType] = scala
      .Option(impl.recipeType())
      .map(value => zio.aws.personalize.model.primitives.RecipeType(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Recipe
  ): zio.aws.personalize.model.Recipe.ReadOnly = new Wrapper(impl)
}
