package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Date, Status, Arn, Name}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RecommenderSummary(
    name: Option[Name] = None,
    recommenderArn: Option[Arn] = None,
    datasetGroupArn: Option[Arn] = None,
    recipeArn: Option[Arn] = None,
    recommenderConfig: Option[zio.aws.personalize.model.RecommenderConfig] =
      None,
    status: Option[Status] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.RecommenderSummary = {
    import RecommenderSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.RecommenderSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(recommenderConfig.map(value => value.buildAwsValue()))(
        _.recommenderConfig
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.RecommenderSummary.ReadOnly =
    zio.aws.personalize.model.RecommenderSummary.wrap(buildAwsValue())
}
object RecommenderSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.RecommenderSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.RecommenderSummary =
      zio.aws.personalize.model.RecommenderSummary(
        name.map(value => value),
        recommenderArn.map(value => value),
        datasetGroupArn.map(value => value),
        recipeArn.map(value => value),
        recommenderConfig.map(value => value.asEditable),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Option[Name]
    def recommenderArn: Option[Arn]
    def datasetGroupArn: Option[Arn]
    def recipeArn: Option[Arn]
    def recommenderConfig
        : Option[zio.aws.personalize.model.RecommenderConfig.ReadOnly]
    def status: Option[Status]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getRecommenderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("recommenderConfig", recommenderConfig)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.RecommenderSummary
  ) extends zio.aws.personalize.model.RecommenderSummary.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val recommenderArn: Option[Arn] = scala
      .Option(impl.recommenderArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val recipeArn: Option[Arn] = scala
      .Option(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val recommenderConfig
        : Option[zio.aws.personalize.model.RecommenderConfig.ReadOnly] = scala
      .Option(impl.recommenderConfig())
      .map(value => zio.aws.personalize.model.RecommenderConfig.wrap(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.RecommenderSummary
  ): zio.aws.personalize.model.RecommenderSummary.ReadOnly = new Wrapper(impl)
}
