package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{FailureReason, Status, Date}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RecommenderUpdateSummary(
    recommenderConfig: Option[zio.aws.personalize.model.RecommenderConfig] =
      None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None,
    status: Option[Status] = None,
    failureReason: Option[FailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.RecommenderUpdateSummary = {
    import RecommenderUpdateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.RecommenderUpdateSummary
      .builder()
      .optionallyWith(recommenderConfig.map(value => value.buildAwsValue()))(
        _.recommenderConfig
      )
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly =
    zio.aws.personalize.model.RecommenderUpdateSummary.wrap(buildAwsValue())
}
object RecommenderUpdateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.RecommenderUpdateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.RecommenderUpdateSummary =
      zio.aws.personalize.model.RecommenderUpdateSummary(
        recommenderConfig.map(value => value.asEditable),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        status.map(value => value),
        failureReason.map(value => value)
      )
    def recommenderConfig
        : Option[zio.aws.personalize.model.RecommenderConfig.ReadOnly]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def status: Option[Status]
    def failureReason: Option[FailureReason]
    def getRecommenderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("recommenderConfig", recommenderConfig)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.RecommenderUpdateSummary
  ) extends zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly {
    override val recommenderConfig
        : Option[zio.aws.personalize.model.RecommenderConfig.ReadOnly] = scala
      .Option(impl.recommenderConfig())
      .map(value => zio.aws.personalize.model.RecommenderConfig.wrap(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.RecommenderUpdateSummary
  ): zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly = new Wrapper(
    impl
  )
}
