package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  PerformAutoML,
  Status,
  Date,
  FailureReason,
  Arn,
  EventType,
  PerformHPO,
  TrainingHours
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SolutionVersion(
    solutionVersionArn: Option[Arn] = None,
    solutionArn: Option[Arn] = None,
    performHPO: Option[PerformHPO] = None,
    performAutoML: Option[PerformAutoML] = None,
    recipeArn: Option[Arn] = None,
    eventType: Option[EventType] = None,
    datasetGroupArn: Option[Arn] = None,
    solutionConfig: Option[zio.aws.personalize.model.SolutionConfig] = None,
    trainingHours: Option[TrainingHours] = None,
    trainingMode: Option[zio.aws.personalize.model.TrainingMode] = None,
    tunedHPOParams: Option[zio.aws.personalize.model.TunedHPOParams] = None,
    status: Option[Status] = None,
    failureReason: Option[FailureReason] = None,
    creationDateTime: Option[Date] = None,
    lastUpdatedDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.SolutionVersion = {
    import SolutionVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.SolutionVersion
      .builder()
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .optionallyWith(
        performHPO.map(value => PerformHPO.unwrap(value): java.lang.Boolean)
      )(_.performHPO)
      .optionallyWith(
        performAutoML.map(value =>
          PerformAutoML.unwrap(value): java.lang.Boolean
        )
      )(_.performAutoML)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(
        eventType.map(value => EventType.unwrap(value): java.lang.String)
      )(_.eventType)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(solutionConfig.map(value => value.buildAwsValue()))(
        _.solutionConfig
      )
      .optionallyWith(
        trainingHours.map(value =>
          TrainingHours.unwrap(value): java.lang.Double
        )
      )(_.trainingHours)
      .optionallyWith(trainingMode.map(value => value.unwrap))(_.trainingMode)
      .optionallyWith(tunedHPOParams.map(value => value.buildAwsValue()))(
        _.tunedHPOParams
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.SolutionVersion.ReadOnly =
    zio.aws.personalize.model.SolutionVersion.wrap(buildAwsValue())
}
object SolutionVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.SolutionVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.SolutionVersion =
      zio.aws.personalize.model.SolutionVersion(
        solutionVersionArn.map(value => value),
        solutionArn.map(value => value),
        performHPO.map(value => value),
        performAutoML.map(value => value),
        recipeArn.map(value => value),
        eventType.map(value => value),
        datasetGroupArn.map(value => value),
        solutionConfig.map(value => value.asEditable),
        trainingHours.map(value => value),
        trainingMode.map(value => value),
        tunedHPOParams.map(value => value.asEditable),
        status.map(value => value),
        failureReason.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def solutionVersionArn: Option[Arn]
    def solutionArn: Option[Arn]
    def performHPO: Option[PerformHPO]
    def performAutoML: Option[PerformAutoML]
    def recipeArn: Option[Arn]
    def eventType: Option[EventType]
    def datasetGroupArn: Option[Arn]
    def solutionConfig
        : Option[zio.aws.personalize.model.SolutionConfig.ReadOnly]
    def trainingHours: Option[TrainingHours]
    def trainingMode: Option[zio.aws.personalize.model.TrainingMode]
    def tunedHPOParams
        : Option[zio.aws.personalize.model.TunedHPOParams.ReadOnly]
    def status: Option[Status]
    def failureReason: Option[FailureReason]
    def creationDateTime: Option[Date]
    def lastUpdatedDateTime: Option[Date]
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
    def getPerformHPO: ZIO[Any, AwsError, PerformHPO] =
      AwsError.unwrapOptionField("performHPO", performHPO)
    def getPerformAutoML: ZIO[Any, AwsError, PerformAutoML] =
      AwsError.unwrapOptionField("performAutoML", performAutoML)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getEventType: ZIO[Any, AwsError, EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getSolutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("solutionConfig", solutionConfig)
    def getTrainingHours: ZIO[Any, AwsError, TrainingHours] =
      AwsError.unwrapOptionField("trainingHours", trainingHours)
    def getTrainingMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.TrainingMode] =
      AwsError.unwrapOptionField("trainingMode", trainingMode)
    def getTunedHPOParams: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.TunedHPOParams.ReadOnly
    ] = AwsError.unwrapOptionField("tunedHPOParams", tunedHPOParams)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.SolutionVersion
  ) extends zio.aws.personalize.model.SolutionVersion.ReadOnly {
    override val solutionVersionArn: Option[Arn] = scala
      .Option(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val solutionArn: Option[Arn] = scala
      .Option(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val performHPO: Option[PerformHPO] = scala
      .Option(impl.performHPO())
      .map(value => zio.aws.personalize.model.primitives.PerformHPO(value))
    override val performAutoML: Option[PerformAutoML] = scala
      .Option(impl.performAutoML())
      .map(value => zio.aws.personalize.model.primitives.PerformAutoML(value))
    override val recipeArn: Option[Arn] = scala
      .Option(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val eventType: Option[EventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.personalize.model.primitives.EventType(value))
    override val datasetGroupArn: Option[Arn] = scala
      .Option(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val solutionConfig
        : Option[zio.aws.personalize.model.SolutionConfig.ReadOnly] = scala
      .Option(impl.solutionConfig())
      .map(value => zio.aws.personalize.model.SolutionConfig.wrap(value))
    override val trainingHours: Option[TrainingHours] = scala
      .Option(impl.trainingHours())
      .map(value => zio.aws.personalize.model.primitives.TrainingHours(value))
    override val trainingMode: Option[zio.aws.personalize.model.TrainingMode] =
      scala
        .Option(impl.trainingMode())
        .map(value => zio.aws.personalize.model.TrainingMode.wrap(value))
    override val tunedHPOParams
        : Option[zio.aws.personalize.model.TunedHPOParams.ReadOnly] = scala
      .Option(impl.tunedHPOParams())
      .map(value => zio.aws.personalize.model.TunedHPOParams.wrap(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Option[Date] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.SolutionVersion
  ): zio.aws.personalize.model.SolutionVersion.ReadOnly = new Wrapper(impl)
}
