package zio.aws.personalize.model
import scala.jdk.CollectionConverters.*
sealed trait TrainingMode {
  def unwrap: software.amazon.awssdk.services.personalize.model.TrainingMode
}
object TrainingMode {
  def wrap(
      value: software.amazon.awssdk.services.personalize.model.TrainingMode
  ): zio.aws.personalize.model.TrainingMode = value match {
    case software.amazon.awssdk.services.personalize.model.TrainingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.personalize.model.TrainingMode.FULL =>
      val r = FULL
      r
    case software.amazon.awssdk.services.personalize.model.TrainingMode.UPDATE =>
      val r = UPDATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.personalize.model.TrainingMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.TrainingMode =
      software.amazon.awssdk.services.personalize.model.TrainingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL extends zio.aws.personalize.model.TrainingMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.TrainingMode =
      software.amazon.awssdk.services.personalize.model.TrainingMode.FULL
  }
  case object UPDATE extends zio.aws.personalize.model.TrainingMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.TrainingMode =
      software.amazon.awssdk.services.personalize.model.TrainingMode.UPDATE
  }
}
